/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;

public class MUCUser
implements PacketExtension {
    public static final String ELEMENT = "x";
    public static final String NAMESPACE = "http://jabber.org/protocol/muc#user";
    private final Set<Status> statusCodes = new HashSet<Status>(4);
    private Invite invite;
    private Decline decline;
    private MUCItem item;
    private String password;
    private Destroy destroy;

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder((PacketExtension)this);
        xml.rightAngleBracket();
        xml.optElement((Element)this.getInvite());
        xml.optElement((Element)this.getDecline());
        xml.optElement((Element)this.getItem());
        xml.optElement("password", this.getPassword());
        xml.append(this.statusCodes);
        xml.optElement((Element)this.getDestroy());
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public Invite getInvite() {
        return this.invite;
    }

    public Decline getDecline() {
        return this.decline;
    }

    public MUCItem getItem() {
        return this.item;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Status> getStatus() {
        return this.statusCodes;
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setInvite(Invite invite) {
        this.invite = invite;
    }

    public void setDecline(Decline decline) {
        this.decline = decline;
    }

    public void setItem(MUCItem item) {
        this.item = item;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void addStatusCodes(Set<Status> statusCodes) {
        this.statusCodes.addAll(statusCodes);
    }

    public void addStatusCode(Status status) {
        this.statusCodes.add(status);
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    @Deprecated
    public static MUCUser getFrom(Packet packet) {
        return MUCUser.from(packet);
    }

    public static MUCUser from(Packet packet) {
        return (MUCUser)packet.getExtension(ELEMENT, NAMESPACE);
    }

    public static class Status
    implements NamedElement {
        public static final String ELEMENT = "status";
        private static final Map<Integer, Status> statusMap = new HashMap<Integer, Status>(8);
        public static final Status ROOM_CREATED_201 = Status.create(201);
        public static final Status BANNED_301 = Status.create(301);
        public static final Status NEW_NICKNAME_303 = Status.create(303);
        public static final Status KICKED_307 = Status.create(307);
        public static final Status REMOVED_AFFIL_CHANGE_321 = Status.create(321);
        private final Integer code;

        public static Status create(String string) {
            Integer integer = Integer.valueOf(string);
            return Status.create(integer);
        }

        public static Status create(Integer i) {
            Status status = statusMap.get(i);
            if (status == null) {
                status = new Status(i);
                statusMap.put(i, status);
            }
            return status;
        }

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("code", this.getCode());
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Status) {
                Status otherStatus = (Status)other;
                return this.code.equals(otherStatus.getCode());
            }
            return false;
        }

        public int hashCode() {
            return this.code;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Decline
    implements NamedElement {
        public static final String ELEMENT = "decline";
        private String reason;
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.optAttribute("to", this.getTo());
            xml.optAttribute("from", this.getFrom());
            xml.rightAngleBracket();
            xml.optElement("reason", this.getReason());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Invite
    implements NamedElement {
        public static final String ELEMENT = "invite";
        private String reason;
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.optAttribute("to", this.getTo());
            xml.optAttribute("from", this.getFrom());
            xml.rightAngleBracket();
            xml.optElement("reason", this.getReason());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }
}

