/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;

public final class PubSubManager {
    private XMPPConnection con;
    private String to;
    private Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public PubSubManager(XMPPConnection connection) {
        this.con = connection;
        this.to = "pubsub." + connection.getServiceName();
    }

    public PubSubManager(XMPPConnection connection, String toAddress) {
        this.con = connection;
        this.to = toAddress;
    }

    public LeafNode createNode() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.CREATE), null);
        NodeExtension elem = (NodeExtension)reply.getExtension("create", PubSubNamespace.BASIC.getXmlns());
        LeafNode newNode = new LeafNode(this.con, elem.getNode());
        newNode.setTo(this.to);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public LeafNode createNode(String id) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return (LeafNode)this.createNode(id, null);
    }

    public Node createNode(String name, Form config) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub request = PubSub.createPubsubPacket(this.to, IQ.Type.set, new NodeExtension(PubSubElementType.CREATE, name), null);
        boolean isLeafNode = true;
        if (config != null) {
            request.addExtension(new FormNode(FormNodeType.CONFIGURE, config));
            FormField nodeTypeField = config.getField(ConfigureNodeFields.node_type.getFieldName());
            if (nodeTypeField != null) {
                isLeafNode = nodeTypeField.getValues().get(0).equals(NodeType.leaf.toString());
            }
        }
        PubSubManager.sendPubsubPacket(this.con, request);
        Node newNode = isLeafNode ? new LeafNode(this.con, name) : new CollectionNode(this.con, name);
        newNode.setTo(this.to);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public <T extends Node> T getNode(String id) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Node node = this.nodeMap.get(id);
        if (node == null) {
            DiscoverInfo info = new DiscoverInfo();
            info.setTo(this.to);
            info.setNode(id);
            DiscoverInfo infoReply = (DiscoverInfo)this.con.createPacketCollectorAndSend((IQ)info).nextResultOrThrow();
            if (infoReply.hasIdentity("pubsub", "leaf")) {
                node = new LeafNode(this.con, id);
            } else if (infoReply.hasIdentity("pubsub", "collection")) {
                node = new CollectionNode(this.con, id);
            } else {
                throw new AssertionError((Object)("PubSub service '" + this.to + "' returned disco info result for node '" + id + "', but it did not contain an Identity of type 'leaf' or 'collection' (and category 'pubsub'), which is not allowed according to XEP-60 5.3."));
            }
            node.setTo(this.to);
            this.nodeMap.put(id, node);
        }
        return (T)node;
    }

    public DiscoverItems discoverNodes(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems items = new DiscoverItems();
        if (nodeId != null) {
            items.setNode(nodeId);
        }
        items.setTo(this.to);
        DiscoverItems nodeItems = (DiscoverItems)this.con.createPacketCollectorAndSend((IQ)items).nextResultOrThrow();
        return nodeItems;
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subElem.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        AffiliationsExtension listElem = (AffiliationsExtension)reply.getExtension(PubSubElementType.AFFILIATIONS);
        return listElem.getAffiliations();
    }

    public void deleteNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.DELETE, nodeId), PubSubElementType.DELETE.getNamespace());
        this.nodeMap.remove(nodeId);
    }

    public ConfigureForm getDefaultConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket((Packet)reply, PubSubElementType.DEFAULT);
    }

    public DiscoverInfo getSupportedFeatures() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager mgr = ServiceDiscoveryManager.getInstanceFor(this.con);
        return mgr.discoverInfo(this.to);
    }

    private PubSub sendPubsubPacket(IQ.Type type, PacketExtension ext, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, Collections.singletonList(ext), ns);
    }

    static PubSub sendPubsubPacket(XMPPConnection con, String to, IQ.Type type, List<PacketExtension> extList, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = new PubSub(to, type, ns);
        for (PacketExtension pe : extList) {
            pubSub.addExtension(pe);
        }
        return PubSubManager.sendPubsubPacket(con, pubSub);
    }

    static PubSub sendPubsubPacket(XMPPConnection con, PubSub packet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        IQ resultIQ = (IQ)con.createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
        if (resultIQ instanceof EmptyResultIQ) {
            return null;
        }
        return (PubSub)resultIQ;
    }
}

