/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.RosterPacketProvider;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;
import org.jivesoftware.smackx.xdatavalidation.provider.DataValidationProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataFormProvider
extends PacketExtensionProvider<DataForm> {
    /*
     * Enabled aggressive block sorting
     */
    public DataForm parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        DataForm.Type dataFormType = DataForm.Type.fromString(parser.getAttributeValue("", "type"));
        DataForm dataForm = new DataForm(dataFormType);
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (name) {
                        case "instructions": {
                            dataForm.addInstruction(parser.nextText());
                            break;
                        }
                        case "title": {
                            dataForm.setTitle(parser.nextText());
                            break;
                        }
                        case "field": {
                            dataForm.addField(this.parseField(parser));
                            break;
                        }
                        case "item": {
                            dataForm.addItem(this.parseItem(parser));
                            break;
                        }
                        case "reported": {
                            dataForm.setReportedData(this.parseReported(parser));
                            break;
                        }
                        case "query": {
                            if (namespace.equals("jabber:iq:roster")) {
                                dataForm.addExtensionElement(RosterPacketProvider.INSTANCE.parse(parser));
                                break;
                            }
                            break block0;
                        }
                        case "page": {
                            if (namespace.equals("http://jabber.org/protocol/xdata-layout")) {
                                dataForm.addExtensionElement((Element)DataLayoutProvider.parse(parser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return dataForm;
                }
            }
        }
    }

    private FormField parseField(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        FormField formField = new FormField(parser.getAttributeValue("", "var"));
        formField.setLabel(parser.getAttributeValue("", "label"));
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null) {
            formField.setType(FormField.Type.fromString(typeString));
        }
        block18: while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (name) {
                        case "desc": {
                            formField.setDescription(parser.nextText());
                            break;
                        }
                        case "value": {
                            formField.addValue(parser.nextText());
                            break;
                        }
                        case "required": {
                            formField.setRequired(true);
                            break;
                        }
                        case "option": {
                            formField.addOption(this.parseOption(parser));
                            break;
                        }
                        case "validate": {
                            if (!namespace.equals("http://jabber.org/protocol/xdata-validate")) break;
                            formField.setValidateElement(DataValidationProvider.parse(parser));
                        }
                    }
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block18;
                }
                default: {
                    continue block18;
                }
            }
            break;
        }
        return formField;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DataForm.Item parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            fields.add(this.parseField(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.Item(fields);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private DataForm.ReportedData parseReported(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            fields.add(this.parseField(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.ReportedData(fields);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private FormField.Option parseOption(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        FormField.Option option = null;
        String label = parser.getAttributeValue("", "label");
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "value": {
                            option = new FormField.Option(label, parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return option;
                }
            }
        }
    }
}

