/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqregister;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jxmpp.util.XmppStringUtils;

public class AccountManager
extends Manager {
    private static final Map<XMPPConnection, AccountManager> INSTANCES = new WeakHashMap<XMPPConnection, AccountManager>();
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public static synchronized AccountManager getInstance(XMPPConnection connection) {
        AccountManager accountManager = INSTANCES.get(connection);
        if (accountManager == null) {
            accountManager = new AccountManager(connection);
            INSTANCES.put(connection, accountManager);
        }
        return accountManager;
    }

    private AccountManager(XMPPConnection connection) {
        super(connection);
    }

    void setSupportsAccountCreation(boolean accountCreationSupported) {
        this.accountCreationSupported = accountCreationSupported;
    }

    public boolean supportsAccountCreation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.accountCreationSupported) {
            return true;
        }
        if (this.info == null) {
            this.getRegistrationInfo();
            this.accountCreationSupported = this.info.getType() != IQ.Type.error;
        }
        return this.accountCreationSupported;
    }

    public Set<String> getAccountAttributes() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Map<String, String> attributes;
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        if ((attributes = this.info.getAttributes()) != null) {
            return Collections.unmodifiableSet(attributes.keySet());
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String name) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getAttributes().get(name);
    }

    public String getAccountInstructions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getInstructions();
    }

    public void createAccount(String username, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String attributeName : this.getAccountAttributes()) {
            attributes.put(attributeName, "");
        }
        this.createAccount(username, password, attributes);
    }

    public void createAccount(String username, String password, Map<String, String> attributes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        attributes.put("username", username);
        attributes.put("password", password);
        Registration reg = new Registration(attributes);
        reg.setType(IQ.Type.set);
        reg.setTo(this.connection().getServiceName());
        this.createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    public void changePassword(String newPassword) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", XmppStringUtils.parseLocalpart((String)this.connection().getUser()));
        map.put("password", newPassword);
        Registration reg = new Registration(map);
        reg.setType(IQ.Type.set);
        reg.setTo(this.connection().getServiceName());
        this.createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    public void deleteAccount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("remove", "");
        Registration reg = new Registration(attributes);
        reg.setType(IQ.Type.set);
        reg.setTo(this.connection().getServiceName());
        this.createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    private synchronized void getRegistrationInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setTo(this.connection().getServiceName());
        this.info = (Registration)this.createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    private PacketCollector createPacketCollectorAndSend(IQ req) throws SmackException.NotConnectedException {
        PacketCollector collector = this.connection().createPacketCollectorAndSend((PacketFilter)new PacketIDFilter(req.getStanzaId()), (Stanza)req);
        return collector;
    }
}

