/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.SmackExecutorThreadFactory;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.packet.Ping;

public class PingManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PingManager.class.getName());
    private static final Map<XMPPConnection, PingManager> INSTANCES = new WeakHashMap<XMPPConnection, PingManager>();
    private static int defaultPingInterval;
    private final Set<PingFailedListener> pingFailedListeners = Collections.synchronizedSet(new HashSet());
    private final ScheduledExecutorService executorService;
    private int pingInterval = defaultPingInterval;
    private ScheduledFuture<?> nextAutomaticPing;
    private final Runnable pingServerRunnable = new Runnable(){

        @Override
        public void run() {
            LOGGER.fine("ServerPingTask run()");
            PingManager.this.pingServerIfNecessary();
        }
    };

    public static synchronized PingManager getInstanceFor(XMPPConnection connection) {
        PingManager pingManager = INSTANCES.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
            INSTANCES.put(connection, pingManager);
        }
        return pingManager;
    }

    public static void setDefaultPingInterval(int interval) {
        defaultPingInterval = interval;
    }

    private PingManager(XMPPConnection connection) {
        super(connection);
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new SmackExecutorThreadFactory(connection.getConnectionCounter(), "Ping"));
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:ping");
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("ping", "urn:xmpp:ping", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                Ping ping = (Ping)iqRequest;
                return ping.getPong();
            }
        });
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                PingManager.this.maybeSchedulePingServerTask();
            }

            public void connectionTerminated() {
                PingManager.this.maybeStopPingServerTask();
            }
        });
        this.maybeSchedulePingServerTask();
    }

    public boolean ping(String jid, long pingTimeout) throws SmackException.NotConnectedException, SmackException.NoResponseException {
        XMPPConnection connection = this.connection();
        if (!connection.isAuthenticated()) {
            throw new SmackException.NotConnectedException();
        }
        Ping ping = new Ping(jid);
        try {
            connection.createPacketCollectorAndSend((IQ)ping).nextResultOrThrow(pingTimeout);
        }
        catch (XMPPException exc) {
            return jid.equals(connection.getServiceName());
        }
        return true;
    }

    public boolean ping(String jid) throws SmackException.NotConnectedException, SmackException.NoResponseException {
        return this.ping(jid, this.connection().getPacketReplyTimeout());
    }

    public boolean isPingSupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:ping");
    }

    public boolean pingMyServer() throws SmackException.NotConnectedException {
        return this.pingMyServer(true);
    }

    public boolean pingMyServer(boolean notifyListeners) throws SmackException.NotConnectedException {
        return this.pingMyServer(notifyListeners, this.connection().getPacketReplyTimeout());
    }

    public boolean pingMyServer(boolean notifyListeners, long pingTimeout) throws SmackException.NotConnectedException {
        boolean res;
        try {
            res = this.ping(this.connection().getServiceName(), pingTimeout);
        }
        catch (SmackException.NoResponseException e) {
            res = false;
        }
        if (!res && notifyListeners) {
            for (PingFailedListener l : this.pingFailedListeners) {
                l.pingFailed();
            }
        }
        return res;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
        this.maybeSchedulePingServerTask();
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.add(listener);
    }

    public void unregisterPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.remove(listener);
    }

    private void maybeSchedulePingServerTask() {
        this.maybeSchedulePingServerTask(0);
    }

    private synchronized void maybeSchedulePingServerTask(int delta) {
        this.maybeStopPingServerTask();
        if (this.pingInterval > 0) {
            int nextPingIn = this.pingInterval - delta;
            LOGGER.fine("Scheduling ServerPingTask in " + nextPingIn + " seconds (pingInterval=" + this.pingInterval + ", delta=" + delta + ")");
            this.nextAutomaticPing = this.executorService.schedule(this.pingServerRunnable, (long)nextPingIn, TimeUnit.SECONDS);
        }
    }

    private void maybeStopPingServerTask() {
        if (this.nextAutomaticPing != null) {
            this.nextAutomaticPing.cancel(true);
            this.nextAutomaticPing = null;
        }
    }

    public synchronized void pingServerIfNecessary() {
        long now;
        int deltaInSeconds;
        int DELTA = 1000;
        int TRIES = 3;
        XMPPConnection connection = this.connection();
        if (connection == null) {
            return;
        }
        if (this.pingInterval <= 0) {
            return;
        }
        long lastStanzaReceived = connection.getLastStanzaReceived();
        if (lastStanzaReceived > 0L && (deltaInSeconds = (int)(((now = System.currentTimeMillis()) - lastStanzaReceived) / 1000L)) < this.pingInterval) {
            this.maybeSchedulePingServerTask(deltaInSeconds);
            return;
        }
        if (connection.isAuthenticated()) {
            boolean res = false;
            for (int i = 0; i < 3; ++i) {
                if (i != 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    res = this.pingMyServer(false);
                }
                catch (SmackException e) {
                    LOGGER.log(Level.WARNING, "SmackError while pinging server", e);
                    res = false;
                }
                if (res) break;
            }
            if (!res) {
                for (PingFailedListener l : this.pingFailedListeners) {
                    l.pingFailed();
                }
            } else {
                this.maybeSchedulePingServerTask();
            }
        } else {
            LOGGER.warning("XMPPConnection was not authenticated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        LOGGER.fine("finalizing PingManager: Shutting down executor service");
        try {
            this.executorService.shutdown();
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "finalize() threw throwable", t);
        }
        finally {
            super.finalize();
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                PingManager.getInstanceFor(connection);
            }
        });
        defaultPingInterval = 1800;
    }
}

