/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;

public class DeliveryReceiptManager
extends Manager {
    private static final PacketFilter MESSAGES_WITH_DEVLIERY_RECEIPT_REQUEST = new AndFilter(new PacketFilter[]{PacketTypeFilter.MESSAGE, new PacketExtensionFilter((PacketExtension)new DeliveryReceiptRequest())});
    private static final PacketFilter MESSAGES_WITH_DELIVERY_RECEIPT = new AndFilter(new PacketFilter[]{PacketTypeFilter.MESSAGE, new PacketExtensionFilter("received", "urn:xmpp:receipts")});
    private static Map<XMPPConnection, DeliveryReceiptManager> instances = new WeakHashMap<XMPPConnection, DeliveryReceiptManager>();
    private static AutoReceiptMode defaultAutoReceiptMode;
    private AutoReceiptMode autoReceiptMode = defaultAutoReceiptMode;
    private final Set<ReceiptReceivedListener> receiptReceivedListeners = new CopyOnWriteArraySet<ReceiptReceivedListener>();
    private static final PacketListener AUTO_ADD_DELIVERY_RECEIPT_REQUESTS_LISTENER;

    public static void setDefaultAutoReceiptMode(AutoReceiptMode autoReceiptMode) {
        defaultAutoReceiptMode = autoReceiptMode;
    }

    private DeliveryReceiptManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:receipts");
        connection.addAsyncPacketListener(new PacketListener(){

            public void processPacket(Stanza packet) throws SmackException.NotConnectedException {
                DeliveryReceipt dr = DeliveryReceipt.from(packet);
                for (ReceiptReceivedListener l : DeliveryReceiptManager.this.receiptReceivedListeners) {
                    l.onReceiptReceived(packet.getFrom(), packet.getTo(), dr.getId(), packet);
                }
            }
        }, MESSAGES_WITH_DELIVERY_RECEIPT);
        connection.addAsyncPacketListener(new PacketListener(){

            public void processPacket(Stanza packet) throws SmackException.NotConnectedException {
                String from = packet.getFrom();
                XMPPConnection connection = DeliveryReceiptManager.this.connection();
                switch (DeliveryReceiptManager.this.autoReceiptMode) {
                    case disabled: {
                        return;
                    }
                    case ifIsSubscribed: {
                        if (Roster.getInstanceFor((XMPPConnection)connection).isSubscribedToMyPresence(from)) break;
                        return;
                    }
                }
                Message ack = new Message(from, Message.Type.normal);
                ack.addExtension((PacketExtension)new DeliveryReceipt(packet.getStanzaId()));
                connection.sendPacket((Stanza)ack);
            }
        }, MESSAGES_WITH_DEVLIERY_RECEIPT_REQUEST);
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(XMPPConnection connection) {
        DeliveryReceiptManager receiptManager = instances.get(connection);
        if (receiptManager == null) {
            receiptManager = new DeliveryReceiptManager(connection);
            instances.put(connection, receiptManager);
        }
        return receiptManager;
    }

    public boolean isSupported(String jid) throws SmackException, XMPPException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:receipts");
    }

    public void setAutoReceiptMode(AutoReceiptMode autoReceiptMode) {
        this.autoReceiptMode = autoReceiptMode;
    }

    public AutoReceiptMode getAutoReceiptMode() {
        return this.autoReceiptMode;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.add(listener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.remove(listener);
    }

    public void autoAddDeliveryReceiptRequests() {
        this.connection().addPacketSendingListener(AUTO_ADD_DELIVERY_RECEIPT_REQUESTS_LISTENER, MessageTypeFilter.NORMAL_OR_CHAT_OR_HEADLINE);
    }

    public void dontAutoAddDeliveryReceiptRequests() {
        this.connection().removePacketSendingListener(AUTO_ADD_DELIVERY_RECEIPT_REQUESTS_LISTENER);
    }

    public static boolean hasDeliveryReceiptRequest(Message message) {
        return DeliveryReceiptRequest.from((Stanza)message) != null;
    }

    @Deprecated
    public static String addDeliveryReceiptRequest(Message m) {
        return DeliveryReceiptRequest.addTo(m);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                DeliveryReceiptManager.getInstanceFor(connection);
            }
        });
        defaultAutoReceiptMode = AutoReceiptMode.ifIsSubscribed;
        AUTO_ADD_DELIVERY_RECEIPT_REQUESTS_LISTENER = new PacketListener(){

            public void processPacket(Stanza packet) throws SmackException.NotConnectedException {
                Message message = (Message)packet;
                DeliveryReceiptRequest.addTo(message);
            }
        };
    }

    public static enum AutoReceiptMode {
        disabled,
        ifIsSubscribed,
        always;

    }
}

