/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.si.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jxmpp.util.XmppDateTime;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StreamInitiationProvider
extends IQProvider<StreamInitiation> {
    private static final Logger LOGGER = Logger.getLogger(StreamInitiationProvider.class.getName());

    public StreamInitiation parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        boolean done = false;
        String id = parser.getAttributeValue("", "id");
        String mimeType = parser.getAttributeValue("", "mime-type");
        StreamInitiation initiation = new StreamInitiation();
        String name = null;
        String size = null;
        String hash = null;
        String date = null;
        String desc = null;
        boolean isRanged = false;
        DataForm form = null;
        DataFormProvider dataFormProvider = new DataFormProvider();
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("file")) {
                    name = parser.getAttributeValue("", "name");
                    size = parser.getAttributeValue("", "size");
                    hash = parser.getAttributeValue("", "hash");
                    date = parser.getAttributeValue("", "date");
                    continue;
                }
                if (elementName.equals("desc")) {
                    desc = parser.nextText();
                    continue;
                }
                if (elementName.equals("range")) {
                    isRanged = true;
                    continue;
                }
                if (!elementName.equals("x") || !namespace.equals("jabber:x:data")) continue;
                form = (DataForm)dataFormProvider.parse(parser);
                continue;
            }
            if (eventType != 3) continue;
            if (elementName.equals("si")) {
                done = true;
                continue;
            }
            if (!elementName.equals("file")) continue;
            long fileSize = 0L;
            if (size != null && size.trim().length() != 0) {
                try {
                    fileSize = Long.parseLong(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.SEVERE, "Failed to parse file size from " + fileSize, e);
                }
            }
            Date fileDate = new Date();
            if (date != null) {
                try {
                    fileDate = XmppDateTime.parseDate((String)date);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            StreamInitiation.File file = new StreamInitiation.File(name, fileSize);
            file.setHash(hash);
            file.setDate(fileDate);
            file.setDesc(desc);
            file.setRanged(isRanged);
            initiation.setFile(file);
        }
        initiation.setSessionID(id);
        initiation.setMimeType(mimeType);
        initiation.setFeatureNegotiationForm(form);
        return initiation;
    }
}

