/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatalayout.provider;

import java.io.IOException;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.xdatalayout.packet.DataLayout;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataLayoutProvider {
    public static DataLayout parse(XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        DataLayout dataLayout = new DataLayout(parser.getAttributeValue("", "label"));
        DataLayoutProvider.parseLayout(dataLayout.getPageLayout(), parser);
        return dataLayout;
    }

    private static DataLayout.Section parseSection(XmlPullParser parser) throws XmlPullParserException, IOException {
        DataLayout.Section layout = new DataLayout.Section(parser.getAttributeValue("", "label"));
        DataLayoutProvider.parseLayout(layout.getSectionLayout(), parser);
        return layout;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseLayout(List<DataLayout.DataFormLayoutElement> layout, XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    switch (parser.getName()) {
                        case "text": {
                            layout.add(new DataLayout.Text(parser.nextText()));
                            break block0;
                        }
                        case "section": {
                            layout.add(DataLayoutProvider.parseSection(parser));
                            break block0;
                        }
                        case "fieldref": {
                            layout.add(DataLayoutProvider.parseFieldref(parser));
                            break block0;
                        }
                        case "reportedref": {
                            layout.add(new DataLayout.Reportedref());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    private static DataLayout.Fieldref parseFieldref(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType;
        int initialDepth = parser.getDepth();
        DataLayout.Fieldref fieldref = new DataLayout.Fieldref(parser.getAttributeValue("", "var"));
        while ((eventType = parser.next()) != 3 || parser.getDepth() != initialDepth) {
        }
        return fieldref;
    }
}

