/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.forward.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.delay.provider.DelayInformationProvider;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ForwardedProvider
extends ExtensionElementProvider<Forwarded> {
    private static final Logger LOGGER = Logger.getLogger(ForwardedProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public Forwarded parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        DelayInformation di = null;
        Message packet = null;
        block12: while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (name) {
                        case "delay": {
                            if ("urn:xmpp:delay".equals(namespace)) {
                                di = DelayInformationProvider.INSTANCE.parse(parser, parser.getDepth());
                                break block0;
                            }
                            LOGGER.warning("Namespace '" + namespace + "' does not match expected namespace '" + "urn:xmpp:delay" + "'");
                            break block0;
                        }
                        case "message": {
                            packet = PacketParserUtils.parseMessage((XmlPullParser)parser);
                            break block0;
                        }
                    }
                    LOGGER.warning("Unsupported forwarded packet type: " + name);
                    break;
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block12;
                }
            }
        }
        if (packet == null) {
            throw new SmackException("forwarded extension must contain a packet");
        }
        return new Forwarded(di, (Stanza)packet);
    }
}

