/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MUCParserUtils {
    /*
     * Enabled aggressive block sorting
     */
    public static MUCItem parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        MUCAffiliation affiliation = MUCAffiliation.fromString(parser.getAttributeValue("", "affiliation"));
        String nick = parser.getAttributeValue("", "nick");
        MUCRole role = MUCRole.fromString(parser.getAttributeValue("", "role"));
        String jid = parser.getAttributeValue("", "jid");
        String actor = null;
        String reason = null;
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "actor": {
                            actor = parser.getAttributeValue("", "jid");
                            break block0;
                        }
                        case "reason": {
                            reason = parser.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new MUCItem(affiliation, role, actor, reason, jid, nick);
                }
            }
        }
    }

    public static Destroy parseDestroy(XmlPullParser parser) throws XmlPullParserException, IOException {
        boolean done = false;
        Destroy destroy = new Destroy();
        destroy.setJid(parser.getAttributeValue("", "jid"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                destroy.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("destroy")) continue;
            done = true;
        }
        return destroy;
    }
}

