/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.provider;

import java.io.IOException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BytestreamsProvider
extends IQProvider<Bytestream> {
    public Bytestream parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
        boolean done = false;
        Bytestream toReturn = new Bytestream();
        String id = parser.getAttributeValue("", "sid");
        String mode = parser.getAttributeValue("", "mode");
        String JID = null;
        String host = null;
        String port = null;
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == 2) {
                if (elementName.equals(Bytestream.StreamHost.ELEMENTNAME)) {
                    JID = parser.getAttributeValue("", "jid");
                    host = parser.getAttributeValue("", "host");
                    port = parser.getAttributeValue("", "port");
                    continue;
                }
                if (elementName.equals(Bytestream.StreamHostUsed.ELEMENTNAME)) {
                    toReturn.setUsedHost(parser.getAttributeValue("", "jid"));
                    continue;
                }
                if (!elementName.equals(Bytestream.Activate.ELEMENTNAME)) continue;
                toReturn.setToActivate(parser.getAttributeValue("", "jid"));
                continue;
            }
            if (eventType != 3) continue;
            if (elementName.equals("streamhost")) {
                if (port == null) {
                    toReturn.addStreamHost(JID, host);
                } else {
                    toReturn.addStreamHost(JID, host, Integer.parseInt(port));
                }
                JID = null;
                host = null;
                port = null;
                continue;
            }
            if (!elementName.equals("query")) continue;
            done = true;
        }
        if (mode == null) {
            toReturn.setMode(Bytestream.Mode.tcp);
        } else {
            toReturn.setMode(Bytestream.Mode.fromName(mode));
        }
        toReturn.setSessionID(id);
        return toReturn;
    }
}

