/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.EventManger;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;

public abstract class StreamNegotiator {
    protected static final EventManger<String, IQ, SmackException.NotConnectedException> initationSetEvents = new EventManger();

    protected static StreamInitiation createInitiationAccept(StreamInitiation streamInitiationOffer, String[] namespaces) {
        StreamInitiation response = new StreamInitiation();
        response.setTo(streamInitiationOffer.getFrom());
        response.setFrom(streamInitiationOffer.getTo());
        response.setType(IQ.Type.result);
        response.setStanzaId(streamInitiationOffer.getStanzaId());
        DataForm form = new DataForm(DataForm.Type.submit);
        FormField field = new FormField("stream-method");
        for (String namespace : namespaces) {
            field.addValue(namespace);
        }
        form.addField(field);
        response.setFeatureNegotiationForm(form);
        return response;
    }

    protected final IQ initiateIncomingStream(final XMPPConnection connection, StreamInitiation initiation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IQ streamMethodInitiation;
        final StreamInitiation response = StreamNegotiator.createInitiationAccept(initiation, this.getNamespaces());
        this.newStreamInitiation(initiation.getFrom(), initiation.getSessionID());
        String eventKey = initiation.getFrom().toString() + '\t' + initiation.getSessionID();
        try {
            streamMethodInitiation = (IQ)initationSetEvents.performActionAndWaitForEvent((Object)eventKey, connection.getPacketReplyTimeout(), (EventManger.Callback)new EventManger.Callback<SmackException.NotConnectedException>(){

                public void action() throws SmackException.NotConnectedException {
                    try {
                        connection.sendStanza((Stanza)response);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (streamMethodInitiation == null) {
            throw SmackException.NoResponseException.newWith((XMPPConnection)connection);
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow((Stanza)streamMethodInitiation);
        return streamMethodInitiation;
    }

    protected abstract void newStreamInitiation(Jid var1, String var2);

    abstract InputStream negotiateIncomingStream(Stanza var1) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NoResponseException, SmackException;

    public abstract InputStream createIncomingStream(StreamInitiation var1) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NoResponseException, SmackException;

    public abstract OutputStream createOutgoingStream(String var1, Jid var2, Jid var3) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException, XMPPException, InterruptedException;

    public abstract String[] getNamespaces();

    public static void signal(String eventKey, IQ eventValue) {
        initationSetEvents.signalEvent((Object)eventKey, (Object)eventValue);
    }
}

