/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MUCParserUtils {
    public static MUCItem parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        MUCAffiliation affiliation = MUCAffiliation.fromString(parser.getAttributeValue("", "affiliation"));
        Resourcepart nick = ParserUtils.getResourcepartAttribute((XmlPullParser)parser, (String)"nick");
        MUCRole role = MUCRole.fromString(parser.getAttributeValue("", "role"));
        Jid jid = ParserUtils.getJidAttribute((XmlPullParser)parser);
        Jid actor = null;
        String reason = null;
        block12: while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "actor": {
                            actor = ParserUtils.getJidAttribute((XmlPullParser)parser);
                            break;
                        }
                        case "reason": {
                            reason = parser.nextText();
                        }
                    }
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block12;
                }
                default: {
                    continue block12;
                }
            }
            break;
        }
        return new MUCItem(affiliation, role, actor, reason, jid, nick);
    }

    public static Destroy parseDestroy(XmlPullParser parser) throws XmlPullParserException, IOException {
        boolean done = false;
        Destroy destroy = new Destroy();
        destroy.setJid(parser.getAttributeValue("", "jid"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                destroy.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("destroy")) continue;
            done = true;
        }
        return destroy;
    }
}

