/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.delay.DelayInformationManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.ConfigurationEvent;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemDeleteEvent;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.OptionsExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.RetractItem;
import org.jivesoftware.smackx.pubsub.SubscribeExtension;
import org.jivesoftware.smackx.pubsub.SubscribeForm;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.UnsubscribeExtension;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.listener.NodeConfigListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.shim.packet.Header;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.xdata.Form;
import org.jxmpp.jid.Jid;

public abstract class Node {
    protected XMPPConnection con;
    protected String id;
    protected Jid to;
    protected ConcurrentHashMap<ItemEventListener<Item>, StanzaListener> itemEventToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<ItemDeleteListener, StanzaListener> itemDeleteToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<NodeConfigListener, StanzaListener> configEventToListenerMap = new ConcurrentHashMap();

    Node(XMPPConnection connection, String nodeName) {
        this.con = connection;
        this.id = nodeName;
    }

    void setTo(Jid toAddress) {
        this.to = toAddress;
    }

    public String getId() {
        return this.id;
    }

    public ConfigureForm getNodeConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.CONFIGURE_OWNER, this.getId()), PubSubNamespace.OWNER);
        PubSub reply = this.sendPubsubPacket(pubSub);
        return NodeUtils.getFormFromPacket((Stanza)reply, PubSubElementType.CONFIGURE_OWNER);
    }

    public void sendConfigurationForm(Form submitForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.set, new FormNode(FormNodeType.CONFIGURE_OWNER, this.getId(), submitForm), PubSubNamespace.OWNER);
        this.con.createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
    }

    public DiscoverInfo discoverInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info = new DiscoverInfo();
        info.setTo(this.to);
        info.setNode(this.getId());
        return (DiscoverInfo)this.con.createPacketCollectorAndSend((IQ)info).nextResultOrThrow();
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptions(null, null);
    }

    public List<Subscription> getSubscriptions(List<ExtensionElement> additionalExtensions, Collection<ExtensionElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptions(additionalExtensions, returnedExtensions, null);
    }

    public List<Subscription> getSubscriptionsAsOwner() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptionsAsOwner(null, null);
    }

    public List<Subscription> getSubscriptionsAsOwner(List<ExtensionElement> additionalExtensions, Collection<ExtensionElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptions(additionalExtensions, returnedExtensions, PubSubNamespace.OWNER);
    }

    private List<Subscription> getSubscriptions(List<ExtensionElement> additionalExtensions, Collection<ExtensionElement> returnedExtensions, PubSubNamespace pubSubNamespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS, this.getId()), pubSubNamespace);
        if (additionalExtensions != null) {
            for (ExtensionElement pe : additionalExtensions) {
                pubSub.addExtension(pe);
            }
        }
        PubSub reply = this.sendPubsubPacket(pubSub);
        if (returnedExtensions != null) {
            returnedExtensions.addAll(reply.getExtensions());
        }
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(PubSubElementType.SUBSCRIPTIONS);
        return subElem.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliations(null, null);
    }

    public List<Affiliation> getAffiliations(List<ExtensionElement> additionalExtensions, Collection<ExtensionElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS, this.getId()));
        if (additionalExtensions != null) {
            for (ExtensionElement pe : additionalExtensions) {
                pubSub.addExtension(pe);
            }
        }
        PubSub reply = this.sendPubsubPacket(pubSub);
        if (returnedExtensions != null) {
            returnedExtensions.addAll(reply.getExtensions());
        }
        AffiliationsExtension affilElem = (AffiliationsExtension)reply.getExtension(PubSubElementType.AFFILIATIONS);
        return affilElem.getAffiliations();
    }

    public Subscription subscribe(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension(jid, this.getId()));
        PubSub reply = this.sendPubsubPacket(pubSub);
        return (Subscription)reply.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    public Subscription subscribe(String jid, SubscribeForm subForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension(jid, this.getId()));
        request.addExtension(new FormNode(FormNodeType.OPTIONS, subForm));
        PubSub reply = PubSubManager.sendPubsubPacket(this.con, request);
        return (Subscription)reply.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    public void unsubscribe(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.unsubscribe(jid, null);
    }

    public void unsubscribe(String jid, String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.sendPubsubPacket(this.createPubsubPacket(IQ.Type.set, new UnsubscribeExtension(jid, this.getId(), subscriptionId)));
    }

    public SubscribeForm getSubscriptionOptions(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptionOptions(jid, null);
    }

    public SubscribeForm getSubscriptionOptions(String jid, String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub packet = this.sendPubsubPacket(this.createPubsubPacket(IQ.Type.get, new OptionsExtension(jid, this.getId(), subscriptionId)));
        FormNode ext = (FormNode)packet.getExtension(PubSubElementType.OPTIONS);
        return new SubscribeForm(ext.getForm());
    }

    public void addItemEventListener(ItemEventListener listener) {
        ItemEventTranslator conListener = new ItemEventTranslator(listener);
        this.itemEventToListenerMap.put(listener, conListener);
        this.con.addSyncStanzaListener((StanzaListener)conListener, (StanzaFilter)new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeItemEventListener(ItemEventListener listener) {
        StanzaListener conListener = this.itemEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.con.removeSyncStanzaListener(conListener);
        }
    }

    public void addConfigurationListener(NodeConfigListener listener) {
        NodeConfigTranslator conListener = new NodeConfigTranslator(listener);
        this.configEventToListenerMap.put(listener, conListener);
        this.con.addSyncStanzaListener((StanzaListener)conListener, (StanzaFilter)new EventContentFilter(EventElementType.configuration.toString()));
    }

    public void removeConfigurationListener(NodeConfigListener listener) {
        StanzaListener conListener = this.configEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.con.removeSyncStanzaListener(conListener);
        }
    }

    public void addItemDeleteListener(ItemDeleteListener listener) {
        ItemDeleteTranslator delListener = new ItemDeleteTranslator(listener);
        this.itemDeleteToListenerMap.put(listener, delListener);
        EventContentFilter deleteItem = new EventContentFilter(EventElementType.items.toString(), "retract");
        EventContentFilter purge = new EventContentFilter(EventElementType.purge.toString());
        this.con.addSyncStanzaListener((StanzaListener)delListener, (StanzaFilter)new OrFilter(new StanzaFilter[]{deleteItem, purge}));
    }

    public void removeItemDeleteListener(ItemDeleteListener listener) {
        StanzaListener conListener = this.itemDeleteToListenerMap.remove(listener);
        if (conListener != null) {
            this.con.removeSyncStanzaListener(conListener);
        }
    }

    public String toString() {
        return super.toString() + " " + this.getClass().getName() + " id: " + this.id;
    }

    protected PubSub createPubsubPacket(IQ.Type type, ExtensionElement ext) {
        return this.createPubsubPacket(type, ext, null);
    }

    protected PubSub createPubsubPacket(IQ.Type type, ExtensionElement ext, PubSubNamespace ns) {
        return PubSub.createPubsubPacket(this.to, type, ext, ns);
    }

    protected PubSub sendPubsubPacket(PubSub packet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return PubSubManager.sendPubsubPacket(this.con, packet);
    }

    private static List<String> getSubscriptionIds(Stanza packet) {
        HeadersExtension headers = (HeadersExtension)packet.getExtension("headers", "http://jabber.org/protocol/shim");
        ArrayList<String> values = null;
        if (headers != null) {
            values = new ArrayList<String>(headers.getHeaders().size());
            for (Header header : headers.getHeaders()) {
                values.add(header.getValue());
            }
        }
        return values;
    }

    class EventContentFilter
    implements StanzaFilter {
        private String firstElement;
        private String secondElement;

        EventContentFilter(String elementName) {
            this.firstElement = elementName;
        }

        EventContentFilter(String firstLevelEelement, String secondLevelElement) {
            this.firstElement = firstLevelEelement;
            this.secondElement = secondLevelElement;
        }

        public boolean accept(Stanza packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            if (event == null) {
                return false;
            }
            NodeExtension embedEvent = event.getEvent();
            if (embedEvent == null) {
                return false;
            }
            if (embedEvent.getElementName().equals(this.firstElement)) {
                List<ExtensionElement> secondLevelList;
                if (!embedEvent.getNode().equals(Node.this.getId())) {
                    return false;
                }
                if (this.secondElement == null) {
                    return true;
                }
                if (embedEvent instanceof EmbeddedPacketExtension && (secondLevelList = ((EmbeddedPacketExtension)((Object)embedEvent)).getExtensions()).size() > 0 && secondLevelList.get(0).getElementName().equals(this.secondElement)) {
                    return true;
                }
            }
            return false;
        }
    }

    public class NodeConfigTranslator
    implements StanzaListener {
        private NodeConfigListener listener;

        public NodeConfigTranslator(NodeConfigListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Stanza packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ConfigurationEvent config = (ConfigurationEvent)event.getEvent();
            this.listener.handleNodeConfiguration(config);
        }
    }

    public class ItemDeleteTranslator
    implements StanzaListener {
        private ItemDeleteListener listener;

        public ItemDeleteTranslator(ItemDeleteListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Stanza packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            List<ExtensionElement> extList = event.getExtensions();
            if (extList.get(0).getElementName().equals(PubSubElementType.PURGE_EVENT.getElementName())) {
                this.listener.handlePurge();
            } else {
                ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
                List<? extends ExtensionElement> pubItems = itemsElem.getItems();
                ArrayList<String> items = new ArrayList<String>(pubItems.size());
                for (RetractItem retractItem : pubItems) {
                    items.add(retractItem.getId());
                }
                ItemDeleteEvent eventItems = new ItemDeleteEvent(itemsElem.getNode(), items, Node.getSubscriptionIds(packet));
                this.listener.handleDeletedItems(eventItems);
            }
        }
    }

    public class ItemEventTranslator
    implements StanzaListener {
        private ItemEventListener listener;

        public ItemEventTranslator(ItemEventListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Stanza packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
            ItemPublishEvent<? extends ExtensionElement> eventItems = new ItemPublishEvent<ExtensionElement>(itemsElem.getNode(), itemsElem.getItems(), Node.getSubscriptionIds(packet), DelayInformationManager.getDelayTimestamp(packet));
            this.listener.handlePublishedItems(eventItems);
        }
    }
}

