/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp.packet;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.ExtensionElement;

public class AMPExtension
implements ExtensionElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/amp";
    public static final String ELEMENT = "amp";
    private CopyOnWriteArrayList<Rule> rules = new CopyOnWriteArrayList();
    private boolean perHop = false;
    private final String from;
    private final String to;
    private final Status status;

    public AMPExtension(String from, String to, Status status) {
        this.from = from;
        this.to = to;
        this.status = status;
    }

    public AMPExtension() {
        this.from = null;
        this.to = null;
        this.status = null;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public int getRulesCount() {
        return this.rules.size();
    }

    public synchronized void setPerHop(boolean enabled) {
        this.perHop = enabled;
    }

    public synchronized boolean isPerHop() {
        return this.perHop;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append('\"');
        if (this.status != null) {
            buf.append(" status=\"").append(this.status.toString()).append('\"');
        }
        if (this.to != null) {
            buf.append(" to=\"").append(this.to).append('\"');
        }
        if (this.from != null) {
            buf.append(" from=\"").append(this.from).append('\"');
        }
        if (this.perHop) {
            buf.append(" per-hop=\"true\"");
        }
        buf.append('>');
        for (Rule rule : this.getRules()) {
            buf.append(rule.toXML());
        }
        buf.append("</").append(this.getElementName()).append('>');
        return buf.toString();
    }

    public static enum Status {
        alert,
        error,
        notify;

    }

    public static enum Action {
        alert,
        drop,
        error,
        notify;

        public static final String ATTRIBUTE_NAME = "action";
    }

    public static interface Condition {
        public static final String ATTRIBUTE_NAME = "condition";

        public String getName();

        public String getValue();
    }

    public static class Rule {
        public static final String ELEMENT = "rule";
        private final Action action;
        private final Condition condition;

        public Action getAction() {
            return this.action;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public Rule(Action action, Condition condition) {
            if (action == null) {
                throw new NullPointerException("Can't create Rule with null action");
            }
            if (condition == null) {
                throw new NullPointerException("Can't create Rule with null condition");
            }
            this.action = action;
            this.condition = condition;
        }

        private String toXML() {
            return "<rule action=\"" + this.action.toString() + "\" " + "condition" + "=\"" + this.condition.getName() + "\" " + "value=\"" + this.condition.getValue() + "\"/>";
        }
    }
}

