/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;

public final class Socks5Proxy {
    private static final Logger LOGGER = Logger.getLogger(Socks5Proxy.class.getName());
    private static Socks5Proxy socks5Server;
    private static boolean localSocks5ProxyEnabled;
    private static int localSocks5ProxyPort;
    private Socks5ServerProcess serverProcess;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private final Map<String, Socket> connectionMap = new ConcurrentHashMap<String, Socket>();
    private final List<String> allowedConnections = Collections.synchronizedList(new LinkedList());
    private final Set<String> localAddresses = new LinkedHashSet<String>(4);

    private Socks5Proxy() {
        Enumeration<NetworkInterface> networkInterfaces;
        this.serverProcess = new Socks5ServerProcess();
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
        HashSet<String> localHostAddresses = new HashSet<String>();
        for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            for (InetAddress address : Collections.list(inetAddresses)) {
                localHostAddresses.add(address.getHostAddress());
            }
        }
        if (localHostAddresses.isEmpty()) {
            throw new IllegalStateException("Could not determine any local host address");
        }
        this.replaceLocalAddresses(localHostAddresses);
    }

    public static boolean isLocalSocks5ProxyEnabled() {
        return localSocks5ProxyEnabled;
    }

    public static void setLocalSocks5ProxyEnabled(boolean localSocks5ProxyEnabled) {
        Socks5Proxy.localSocks5ProxyEnabled = localSocks5ProxyEnabled;
    }

    public static int getLocalSocks5ProxyPort() {
        return localSocks5ProxyPort;
    }

    public static void setLocalSocks5ProxyPort(int localSocks5ProxyPort) {
        if (Math.abs(localSocks5ProxyPort) > 65535) {
            throw new IllegalArgumentException("localSocks5ProxyPort must be within (-65535,65535)");
        }
        Socks5Proxy.localSocks5ProxyPort = localSocks5ProxyPort;
    }

    public static synchronized Socks5Proxy getSocks5Proxy() {
        if (socks5Server == null) {
            socks5Server = new Socks5Proxy();
        }
        if (Socks5Proxy.isLocalSocks5ProxyEnabled()) {
            socks5Server.start();
        }
        return socks5Server;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            if (Socks5Proxy.getLocalSocks5ProxyPort() < 0) {
                int port = Math.abs(Socks5Proxy.getLocalSocks5ProxyPort());
                for (int i = 0; i < 65535 - port; ++i) {
                    try {
                        this.serverSocket = new ServerSocket(port + i);
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
            } else {
                this.serverSocket = new ServerSocket(Socks5Proxy.getLocalSocks5ProxyPort());
            }
            if (this.serverSocket != null) {
                this.serverThread = new Thread(this.serverProcess);
                this.serverThread.start();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "couldn't setup local SOCKS5 proxy on port " + Socks5Proxy.getLocalSocks5ProxyPort(), e);
        }
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null && this.serverThread.isAlive()) {
            try {
                this.serverThread.interrupt();
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.serverThread = null;
        this.serverSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalAddress(String address) {
        if (address == null) {
            return;
        }
        Set<String> set = this.localAddresses;
        synchronized (set) {
            this.localAddresses.add(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLocalAddress(String address) {
        Set<String> set = this.localAddresses;
        synchronized (set) {
            return this.localAddresses.remove(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLocalAddresses() {
        Set<String> set = this.localAddresses;
        synchronized (set) {
            return new LinkedList<String>(this.localAddresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLocalAddresses(Collection<String> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        Set<String> set = this.localAddresses;
        synchronized (set) {
            this.localAddresses.clear();
            this.localAddresses.addAll(addresses);
        }
    }

    public int getPort() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    protected Socket getSocket(String digest) {
        return this.connectionMap.get(digest);
    }

    protected void addTransfer(String digest) {
        this.allowedConnections.add(digest);
    }

    protected void removeTransfer(String digest) {
        this.allowedConnections.remove(digest);
        this.connectionMap.remove(digest);
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    static {
        localSocks5ProxyEnabled = true;
        localSocks5ProxyPort = -7777;
    }

    private class Socks5ServerProcess
    implements Runnable {
        private Socks5ServerProcess() {
        }

        @Override
        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    if (Socks5Proxy.this.serverSocket.isClosed() || Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    socket = Socks5Proxy.this.serverSocket.accept();
                    this.establishConnection(socket);
                    continue;
                }
                catch (SocketException socketException) {
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                    continue;
                }
                break;
            }
        }

        private void establishConnection(Socket socket) throws SmackException, IOException {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int b = in.read();
            if (b != 5) {
                throw new SmackException("Only SOCKS5 supported");
            }
            b = in.read();
            byte[] auth = new byte[b];
            in.readFully(auth);
            byte[] authMethodSelectionResponse = new byte[2];
            authMethodSelectionResponse[0] = 5;
            boolean noAuthMethodFound = false;
            for (int i = 0; i < auth.length; ++i) {
                if (auth[i] != 0) continue;
                noAuthMethodFound = true;
                break;
            }
            if (!noAuthMethodFound) {
                authMethodSelectionResponse[1] = -1;
                out.write(authMethodSelectionResponse);
                out.flush();
                throw new SmackException("Authentication method not supported");
            }
            authMethodSelectionResponse[1] = 0;
            out.write(authMethodSelectionResponse);
            out.flush();
            byte[] connectionRequest = Socks5Utils.receiveSocks5Message(in);
            String responseDigest = new String(connectionRequest, 5, (int)connectionRequest[4]);
            if (!Socks5Proxy.this.allowedConnections.contains(responseDigest)) {
                connectionRequest[1] = 5;
                out.write(connectionRequest);
                out.flush();
                throw new SmackException("Connection is not allowed");
            }
            connectionRequest[1] = 0;
            out.write(connectionRequest);
            out.flush();
            Socks5Proxy.this.connectionMap.put(responseDigest, socket);
        }
    }
}

