/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.time.packet.Time;
import org.jxmpp.jid.Jid;

public final class EntityTimeManager
extends Manager {
    private static final Map<XMPPConnection, EntityTimeManager> INSTANCES = new WeakHashMap<XMPPConnection, EntityTimeManager>();
    private static boolean autoEnable = true;
    private boolean enabled = false;

    public static void setAutoEnable(boolean autoEnable) {
        EntityTimeManager.autoEnable = autoEnable;
    }

    public static synchronized EntityTimeManager getInstanceFor(XMPPConnection connection) {
        EntityTimeManager entityTimeManager = INSTANCES.get(connection);
        if (entityTimeManager == null) {
            entityTimeManager = new EntityTimeManager(connection);
            INSTANCES.put(connection, entityTimeManager);
        }
        return entityTimeManager;
    }

    private EntityTimeManager(XMPPConnection connection) {
        super(connection);
        if (autoEnable) {
            this.enable();
        }
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("time", "urn:xmpp:time", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                if (EntityTimeManager.this.enabled) {
                    return Time.createResponse(iqRequest);
                }
                return IQ.createErrorResponse((IQ)iqRequest, (XMPPError.Condition)XMPPError.Condition.not_acceptable);
            }
        });
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        sdm.addFeature("urn:xmpp:time");
        this.enabled = true;
    }

    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        sdm.removeFeature("urn:xmpp:time");
        this.enabled = false;
    }

    public boolean isTimeSupported(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:time");
    }

    public Time getTime(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (!this.isTimeSupported(jid)) {
            return null;
        }
        Time request = new Time();
        Time response = (Time)this.connection().createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                EntityTimeManager.getInstanceFor(connection);
            }
        });
    }
}

