/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.offline.OfflineMessageHeader;
import org.jivesoftware.smackx.offline.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.offline.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.xdata.Form;

public class OfflineMessageManager {
    private static final String namespace = "http://jabber.org/protocol/offline";
    private final XMPPConnection connection;
    private static final StanzaFilter PACKET_FILTER = new AndFilter(new StanzaFilter[]{new StanzaExtensionFilter((ExtensionElement)new OfflineMessageInfo()), StanzaTypeFilter.MESSAGE});

    public OfflineMessageManager(XMPPConnection connection) {
        this.connection = connection;
    }

    public boolean supportsFlexibleRetrieval() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection).serverSupportsFeature(namespace);
    }

    public int getMessageCount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null, namespace);
        Form extendedInfo = Form.getFormFrom((Stanza)info);
        if (extendedInfo != null) {
            String value = extendedInfo.getField("number_of_messages").getValues().get(0);
            return Integer.parseInt(value);
        }
        return 0;
    }

    public List<OfflineMessageHeader> getHeaders() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<OfflineMessageHeader> answer = new ArrayList<OfflineMessageHeader>();
        DiscoverItems items = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverItems(null, namespace);
        for (DiscoverItems.Item item : items.getItems()) {
            answer.add(new OfflineMessageHeader(item));
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages(final List<String> nodes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<Message> messages = new ArrayList<Message>();
        OfflineMessageRequest request = new OfflineMessageRequest();
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("view");
            request.addItem(item);
        }
        AndFilter messageFilter = new AndFilter(new StanzaFilter[]{PACKET_FILTER, new StanzaFilter(){

            public boolean accept(Stanza packet) {
                OfflineMessageInfo info = (OfflineMessageInfo)packet.getExtension("offline", OfflineMessageManager.namespace);
                return nodes.contains(info.getNode());
            }
        }});
        StanzaCollector messageCollector = this.connection.createStanzaCollector((StanzaFilter)messageFilter);
        try {
            this.connection.createStanzaCollectorAndSend((IQ)request).nextResultOrThrow();
            Message message = (Message)messageCollector.nextResult();
            while (message != null) {
                messages.add(message);
                message = (Message)messageCollector.nextResult();
            }
        }
        finally {
            messageCollector.cancel();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setFetch(true);
        StanzaCollector resultCollector = this.connection.createStanzaCollectorAndSend((IQ)request);
        StanzaCollector.Configuration messageCollectorConfiguration = StanzaCollector.newConfiguration().setStanzaFilter(PACKET_FILTER).setCollectorToReset(resultCollector);
        StanzaCollector messageCollector = this.connection.createStanzaCollector(messageCollectorConfiguration);
        ArrayList<Message> messages = null;
        try {
            Message message;
            resultCollector.nextResultOrThrow();
            messageCollector.cancel();
            messages = new ArrayList<Message>(messageCollector.getCollectedCount());
            while ((message = (Message)messageCollector.pollResult()) != null) {
                messages.add(message);
            }
        }
        finally {
            messageCollector.cancel();
        }
        return messages;
    }

    public void deleteMessages(List<String> nodes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setType(IQ.Type.set);
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("remove");
            request.addItem(item);
        }
        this.connection.createStanzaCollectorAndSend((IQ)request).nextResultOrThrow();
    }

    public void deleteMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setType(IQ.Type.set);
        request.setPurge(true);
        this.connection.createStanzaCollectorAndSend((IQ)request).nextResultOrThrow();
    }
}

