/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.jid.Jid;

public class FaultTolerantNegotiator
extends StreamNegotiator {
    private final StreamNegotiator primaryNegotiator;
    private final StreamNegotiator secondaryNegotiator;

    public FaultTolerantNegotiator(XMPPConnection connection, StreamNegotiator primary, StreamNegotiator secondary) {
        super(connection);
        this.primaryNegotiator = primary;
        this.secondaryNegotiator = secondary;
    }

    @Override
    public void newStreamInitiation(Jid from, String streamID) {
        this.primaryNegotiator.newStreamInitiation(from, streamID);
        this.secondaryNegotiator.newStreamInitiation(from, streamID);
    }

    @Override
    InputStream negotiateIncomingStream(Stanza streamInitiation) {
        throw new UnsupportedOperationException("Negotiation only handled by create incoming stream method.");
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws SmackException, XMPPException.XMPPErrorException, InterruptedException {
        IQ initiationSet = this.initiateIncomingStream(this.connection(), initiation);
        StreamNegotiator streamNegotiator = this.determineNegotiator((Stanza)initiationSet);
        return streamNegotiator.negotiateIncomingStream((Stanza)initiationSet);
    }

    private StreamNegotiator determineNegotiator(Stanza streamInitiation) {
        if (streamInitiation instanceof Bytestream) {
            return this.primaryNegotiator;
        }
        if (streamInitiation instanceof Open) {
            return this.secondaryNegotiator;
        }
        throw new IllegalStateException("Unknown stream initation type");
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, Jid initiator, Jid target) throws SmackException, XMPPException, InterruptedException {
        OutputStream stream;
        try {
            stream = this.primaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        catch (Exception ex) {
            stream = this.secondaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        return stream;
    }

    @Override
    public String[] getNamespaces() {
        String[] primary = this.primaryNegotiator.getNamespaces();
        String[] secondary = this.secondaryNegotiator.getNamespaces();
        String[] namespaces = new String[primary.length + secondary.length];
        System.arraycopy(primary, 0, namespaces, 0, primary.length);
        System.arraycopy(secondary, 0, namespaces, primary.length, secondary.length);
        return namespaces;
    }
}

