/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_ibb.element;

import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;

public class JingleIBBTransport
extends JingleContentTransport {
    public static final String NAMESPACE_V1 = "urn:xmpp:jingle:transports:ibb:1";
    public static final String ATTR_BLOCK_SIZE = "block-size";
    public static final String ATTR_SID = "sid";
    public static final short DEFAULT_BLOCK_SIZE = 4096;
    private final short blockSize;
    private final String sid;

    public JingleIBBTransport() {
        this(4096);
    }

    public JingleIBBTransport(String sid) {
        this(4096, sid);
    }

    public JingleIBBTransport(short blockSize) {
        this(blockSize, StringUtils.randomString((int)24));
    }

    public JingleIBBTransport(short blockSize, String sid) {
        super(null);
        this.blockSize = blockSize > 0 ? blockSize : (short)4096;
        this.sid = sid;
    }

    public String getSessionId() {
        return this.sid;
    }

    public short getBlockSize() {
        return this.blockSize;
    }

    @Override
    protected void addExtraAttributes(XmlStringBuilder xml) {
        xml.attribute(ATTR_BLOCK_SIZE, (int)this.blockSize);
        xml.attribute(ATTR_SID, this.sid);
    }

    public String getNamespace() {
        return NAMESPACE_V1;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof JingleIBBTransport)) {
            return false;
        }
        return this == other || this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }
}

