/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.packet;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.InternetAddress;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;

public class Bytestream
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private String sessionID;
    private Mode mode = Mode.tcp;
    private final List<StreamHost> streamHosts = new ArrayList<StreamHost>();
    private StreamHostUsed usedHost;
    private Activate toActivate;

    public Bytestream() {
        super(ELEMENT, NAMESPACE);
    }

    public Bytestream(String SID) {
        this();
        this.setSessionID(SID);
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public StreamHost addStreamHost(Jid JID, String address) {
        return this.addStreamHost(JID, address, 0);
    }

    public StreamHost addStreamHost(Jid JID, String address, int port) {
        StreamHost host = new StreamHost(JID, address, port);
        this.addStreamHost(host);
        return host;
    }

    public void addStreamHost(StreamHost host) {
        this.streamHosts.add(host);
    }

    public List<StreamHost> getStreamHosts() {
        return Collections.unmodifiableList(this.streamHosts);
    }

    public StreamHost getStreamHost(Jid JID) {
        if (JID == null) {
            return null;
        }
        for (StreamHost host : this.streamHosts) {
            if (!host.getJID().equals((CharSequence)JID)) continue;
            return host;
        }
        return null;
    }

    public int countStreamHosts() {
        return this.streamHosts.size();
    }

    public void setUsedHost(Jid JID) {
        this.usedHost = new StreamHostUsed(JID);
    }

    public StreamHostUsed getUsedHost() {
        return this.usedHost;
    }

    public Activate getToActivate() {
        return this.toActivate;
    }

    public void setToActivate(Jid targetID) {
        this.toActivate = new Activate(targetID);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        switch (this.getType()) {
            case set: {
                xml.optAttribute("sid", this.getSessionID());
                xml.optAttribute("mode", (Enum)this.getMode());
                xml.rightAngleBracket();
                if (this.getToActivate() == null) {
                    for (StreamHost streamHost : this.getStreamHosts()) {
                        xml.append(streamHost.toXML());
                    }
                    break;
                }
                xml.append(this.getToActivate().toXML());
                break;
            }
            case result: {
                xml.rightAngleBracket();
                xml.optAppend((Element)this.getUsedHost());
                for (StreamHost host : this.streamHosts) {
                    xml.append(host.toXML());
                }
                break;
            }
            case get: {
                xml.setEmptyElement();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return xml;
    }

    public static enum Mode {
        tcp,
        udp;


        public static Mode fromName(String name) {
            Mode mode;
            try {
                mode = Mode.valueOf(name);
            }
            catch (Exception ex) {
                mode = tcp;
            }
            return mode;
        }
    }

    public static class Activate
    implements NamedElement {
        public static String ELEMENTNAME = "activate";
        private final Jid target;

        public Activate(Jid target) {
            this.target = target;
        }

        public Jid getTarget() {
            return this.target;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.rightAngleBracket();
            xml.escape((CharSequence)this.getTarget());
            xml.closeElement((NamedElement)this);
            return xml;
        }
    }

    public static class StreamHostUsed
    implements NamedElement {
        public static String ELEMENTNAME = "streamhost-used";
        private final Jid jid;

        public StreamHostUsed(Jid jid) {
            this.jid = jid;
        }

        public Jid getJID() {
            return this.jid;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("jid", (CharSequence)this.getJID());
            xml.closeEmptyElement();
            return xml;
        }
    }

    public static class StreamHost
    implements NamedElement {
        public static String ELEMENTNAME = "streamhost";
        private final Jid jid;
        private final InternetAddress address;
        private final int port;

        public StreamHost(Jid jid, String address) {
            this(jid, address, 0);
        }

        public StreamHost(Jid jid, String address, int port) {
            this(jid, InternetAddress.from((String)address), port);
        }

        public StreamHost(Jid jid, InetAddress address, int port) {
            this(jid, InternetAddress.from((InetAddress)address), port);
        }

        public StreamHost(Jid jid, InternetAddress address, int port) {
            this.jid = (Jid)Objects.requireNonNull((Object)jid, (String)"StreamHost JID must not be null");
            this.address = (InternetAddress)Objects.requireNonNull((Object)address);
            this.port = port;
        }

        public Jid getJID() {
            return this.jid;
        }

        public InternetAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("jid", (CharSequence)this.getJID());
            xml.attribute("host", (CharSequence)this.address);
            if (this.getPort() != 0) {
                xml.attribute("port", Integer.toString(this.getPort()));
            } else {
                xml.attribute("zeroconf", "_jabber.bytestreams");
            }
            xml.closeEmptyElement();
            return xml;
        }

        public String toString() {
            return "SOCKS5 Stream Host: " + this.jid + "[" + this.address + ":" + this.port + "]";
        }
    }
}

