/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mediaelement.provider;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;

public class MediaElementProvider
extends FormFieldChildElementProvider<MediaElement> {
    private static final Logger LOGGER = Logger.getLogger(MediaElementProvider.class.getName());

    @Override
    public QName getQName() {
        return MediaElement.QNAME;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws IOException, XmlPullParserException, SmackParsingException.SmackUriSyntaxParsingException {
        UInt16 height = ParserUtils.getUInt16Attribute((XmlPullParser)parser, (String)"height");
        UInt16 width = ParserUtils.getUInt16Attribute((XmlPullParser)parser, (String)"width");
        MediaElement.Builder mediaElementBuilder = MediaElement.builder();
        if (height != null && width != null) {
            mediaElementBuilder.setHeightAndWidth(height, width);
        } else if (height != null || width != null) {
            LOGGER.warning("Only one of height and width set while parsing media element");
        }
        while (true) {
            XmlPullParser.TagEvent event = parser.nextTag();
            switch (event) {
                case START_ELEMENT: {
                    QName qname = parser.getQName();
                    if (!qname.equals(MediaElement.Uri.QNAME)) break;
                    MediaElement.Uri uri = this.parseUri(parser);
                    mediaElementBuilder.addUri(uri);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return mediaElementBuilder.build();
                }
            }
        }
    }

    private MediaElement.Uri parseUri(XmlPullParser parser) throws SmackParsingException.SmackUriSyntaxParsingException, XmlPullParserException, IOException {
        String type = parser.getAttributeValue("type");
        URI uri = ParserUtils.getUriFromNextText((XmlPullParser)parser);
        return new MediaElement.Uri(uri, type);
    }
}

