/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQResultReplyFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.privacy.PrivacyList;
import org.jivesoftware.smackx.privacy.PrivacyListListener;
import org.jivesoftware.smackx.privacy.filter.SetActiveListFilter;
import org.jivesoftware.smackx.privacy.filter.SetDefaultListFilter;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public final class PrivacyListManager
extends Manager {
    public static final String NAMESPACE = "jabber:iq:privacy";
    public static final StanzaFilter PRIVACY_FILTER = new StanzaTypeFilter(Privacy.class);
    private static final StanzaFilter PRIVACY_RESULT = new AndFilter(new StanzaFilter[]{IQTypeFilter.RESULT, PRIVACY_FILTER});
    private static final Map<XMPPConnection, PrivacyListManager> INSTANCES = new WeakHashMap<XMPPConnection, PrivacyListManager>();
    private final Set<PrivacyListListener> listeners = new CopyOnWriteArraySet<PrivacyListListener>();
    private volatile String cachedActiveListName;
    private volatile String cachedDefaultListName;

    private PrivacyListManager(XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iqRequest) {
                Privacy privacy = (Privacy)iqRequest;
                for (PrivacyListListener listener : PrivacyListManager.this.listeners) {
                    for (Map.Entry<String, List<PrivacyItem>> entry : privacy.getItemLists().entrySet()) {
                        String listName = entry.getKey();
                        List<PrivacyItem> items = entry.getValue();
                        if (items.isEmpty()) {
                            listener.updatedPrivacyList(listName);
                            continue;
                        }
                        listener.setPrivacyList(listName, items);
                    }
                }
                return IQ.createResultIQ((IQ)privacy);
            }
        });
        connection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                XMPPConnection connection = PrivacyListManager.this.connection();
                Privacy privacy = (Privacy)packet;
                IQResultReplyFilter iqResultReplyFilter = new IQResultReplyFilter((IQ)privacy, connection);
                final String activeListName = privacy.getActiveName();
                final boolean declinceActiveList = privacy.isDeclineActiveList();
                connection.addOneTimeSyncCallback(new StanzaListener(){

                    public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                        if (declinceActiveList) {
                            PrivacyListManager.this.cachedActiveListName = null;
                        } else {
                            PrivacyListManager.this.cachedActiveListName = activeListName;
                        }
                    }
                }, (StanzaFilter)iqResultReplyFilter);
            }
        }, (StanzaFilter)SetActiveListFilter.INSTANCE);
        connection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                XMPPConnection connection = PrivacyListManager.this.connection();
                Privacy privacy = (Privacy)packet;
                IQResultReplyFilter iqResultReplyFilter = new IQResultReplyFilter((IQ)privacy, connection);
                final String defaultListName = privacy.getDefaultName();
                final boolean declinceDefaultList = privacy.isDeclineDefaultList();
                connection.addOneTimeSyncCallback(new StanzaListener(){

                    public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                        if (declinceDefaultList) {
                            PrivacyListManager.this.cachedDefaultListName = null;
                        } else {
                            PrivacyListManager.this.cachedDefaultListName = defaultListName;
                        }
                    }
                }, (StanzaFilter)iqResultReplyFilter);
            }
        }, (StanzaFilter)SetDefaultListFilter.INSTANCE);
        connection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                String defaultList;
                Privacy privacy = (Privacy)packet;
                String activeList = privacy.getActiveName();
                if (activeList != null) {
                    PrivacyListManager.this.cachedActiveListName = activeList;
                }
                if ((defaultList = privacy.getDefaultName()) != null) {
                    PrivacyListManager.this.cachedDefaultListName = defaultList;
                }
            }
        }, PRIVACY_RESULT);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (resumed) {
                    return;
                }
                PrivacyListManager.this.cachedActiveListName = (PrivacyListManager.this.cachedDefaultListName = null);
            }
        });
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
    }

    public static synchronized PrivacyListManager getInstanceFor(XMPPConnection connection) {
        PrivacyListManager plm = INSTANCES.get(connection);
        if (plm == null) {
            plm = new PrivacyListManager(connection);
            INSTANCES.put(connection, plm);
        }
        return plm;
    }

    private Privacy getRequest(Privacy requestPrivacy) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        requestPrivacy.setType(IQ.Type.get);
        return (Privacy)this.connection().createStanzaCollectorAndSend((IQ)requestPrivacy).nextResultOrThrow();
    }

    private Stanza setRequest(Privacy requestPrivacy) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        requestPrivacy.setType(IQ.Type.set);
        return this.connection().createStanzaCollectorAndSend((IQ)requestPrivacy).nextResultOrThrow();
    }

    private Privacy getPrivacyWithListNames() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        return this.getRequest(request);
    }

    public PrivacyList getActiveList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        String listName = privacyAnswer.getActiveName();
        if (StringUtils.isNullOrEmpty((CharSequence)listName)) {
            return null;
        }
        boolean isDefaultAndActive = listName != null && listName.equals(privacyAnswer.getDefaultName());
        return new PrivacyList(true, isDefaultAndActive, listName, this.getPrivacyListItems(listName));
    }

    public String getActiveListName() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.cachedActiveListName != null) {
            return this.cachedActiveListName;
        }
        return this.getPrivacyWithListNames().getActiveName();
    }

    public PrivacyList getDefaultList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        String listName = privacyAnswer.getDefaultName();
        if (StringUtils.isNullOrEmpty((CharSequence)listName)) {
            return null;
        }
        boolean isDefaultAndActive = listName.equals(privacyAnswer.getActiveName());
        return new PrivacyList(isDefaultAndActive, true, listName, this.getPrivacyListItems(listName));
    }

    public String getDefaultListName() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.cachedDefaultListName != null) {
            return this.cachedDefaultListName;
        }
        return this.getPrivacyWithListNames().getDefaultName();
    }

    public String getEffectiveListName() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String activeListName = this.getActiveListName();
        if (activeListName != null) {
            return activeListName;
        }
        return this.getDefaultListName();
    }

    private List<PrivacyItem> getPrivacyListItems(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        assert (StringUtils.isNotEmpty((CharSequence)listName));
        Privacy request = new Privacy();
        request.setPrivacyList(listName, new ArrayList<PrivacyItem>());
        Privacy privacyAnswer = this.getRequest(request);
        return privacyAnswer.getPrivacyList(listName);
    }

    public PrivacyList getPrivacyList(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        listName = (String)StringUtils.requireNotNullNorEmpty((CharSequence)listName, (String)"List name must not be null");
        return new PrivacyList(false, false, listName, this.getPrivacyListItems(listName));
    }

    public List<PrivacyList> getPrivacyLists() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        Set<String> names = privacyAnswer.getPrivacyListNames();
        ArrayList<PrivacyList> lists = new ArrayList<PrivacyList>(names.size());
        for (String listName : names) {
            boolean isActiveList = listName.equals(privacyAnswer.getActiveName());
            boolean isDefaultList = listName.equals(privacyAnswer.getDefaultName());
            lists.add(new PrivacyList(isActiveList, isDefaultList, listName, this.getPrivacyListItems(listName)));
        }
        return lists;
    }

    public void setActiveListName(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        request.setActiveName(listName);
        this.setRequest(request);
    }

    public void declineActiveList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        request.setDeclineActiveList(true);
        this.setRequest(request);
    }

    public void setDefaultListName(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        request.setDefaultName(listName);
        this.setRequest(request);
    }

    public void declineDefaultList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        request.setDeclineDefaultList(true);
        this.setRequest(request);
    }

    public void createPrivacyList(String listName, List<PrivacyItem> privacyItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.updatePrivacyList(listName, privacyItems);
    }

    public void updatePrivacyList(String listName, List<PrivacyItem> privacyItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, privacyItems);
        this.setRequest(request);
    }

    public void deletePrivacyList(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, new ArrayList<PrivacyItem>());
        this.setRequest(request);
    }

    public boolean addListener(PrivacyListListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(PrivacyListListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                PrivacyListManager.getInstanceFor(connection);
            }
        });
    }
}

