/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.pubsub.AccessModel;
import org.jivesoftware.smackx.pubsub.ChildrenAssociationPolicy;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.ItemReply;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.NotificationType;
import org.jivesoftware.smackx.pubsub.PublishModel;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ConfigureForm
extends Form {
    public ConfigureForm(DataForm configDataForm) {
        super(configDataForm);
    }

    public ConfigureForm(Form nodeConfigForm) {
        super(nodeConfigForm.getDataFormToSend());
    }

    public ConfigureForm(DataForm.Type formType) {
        super(formType);
    }

    public AccessModel getAccessModel() {
        String value = this.getFieldValue(ConfigureNodeFields.access_model);
        if (value == null) {
            return null;
        }
        return AccessModel.valueOf(value);
    }

    public void setAccessModel(AccessModel accessModel) {
        this.addField(ConfigureNodeFields.access_model, FormField.Type.list_single);
        this.setAnswer(ConfigureNodeFields.access_model.getFieldName(), ConfigureForm.getListSingle(accessModel.toString()));
    }

    public String getBodyXSLT() {
        return this.getFieldValue(ConfigureNodeFields.body_xslt);
    }

    public void setBodyXSLT(String bodyXslt) {
        this.addField(ConfigureNodeFields.body_xslt, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.body_xslt.getFieldName(), bodyXslt);
    }

    public List<String> getChildren() {
        return this.getFieldValues(ConfigureNodeFields.children);
    }

    public void setChildren(List<String> children) {
        this.addField(ConfigureNodeFields.children, FormField.Type.text_multi);
        this.setAnswer(ConfigureNodeFields.children.getFieldName(), children);
    }

    public ChildrenAssociationPolicy getChildrenAssociationPolicy() {
        String value = this.getFieldValue(ConfigureNodeFields.children_association_policy);
        if (value == null) {
            return null;
        }
        return ChildrenAssociationPolicy.valueOf(value);
    }

    public void setChildrenAssociationPolicy(ChildrenAssociationPolicy policy) {
        this.addField(ConfigureNodeFields.children_association_policy, FormField.Type.list_single);
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(policy.toString());
        this.setAnswer(ConfigureNodeFields.children_association_policy.getFieldName(), values);
    }

    public List<String> getChildrenAssociationWhitelist() {
        return this.getFieldValues(ConfigureNodeFields.children_association_whitelist);
    }

    public void setChildrenAssociationWhitelist(List<String> whitelist) {
        this.addField(ConfigureNodeFields.children_association_whitelist, FormField.Type.jid_multi);
        this.setAnswer(ConfigureNodeFields.children_association_whitelist.getFieldName(), whitelist);
    }

    public int getChildrenMax() {
        return Integer.parseInt(this.getFieldValue(ConfigureNodeFields.children_max));
    }

    public void setChildrenMax(int max) {
        this.addField(ConfigureNodeFields.children_max, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.children_max.getFieldName(), max);
    }

    public String getCollection() {
        return this.getFieldValue(ConfigureNodeFields.collection);
    }

    public void setCollection(String collection) {
        this.addField(ConfigureNodeFields.collection, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.collection.getFieldName(), collection);
    }

    public String getDataformXSLT() {
        return this.getFieldValue(ConfigureNodeFields.dataform_xslt);
    }

    public void setDataformXSLT(String url) {
        this.addField(ConfigureNodeFields.dataform_xslt, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.dataform_xslt.getFieldName(), url);
    }

    public boolean isDeliverPayloads() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.deliver_payloads));
    }

    public void setDeliverPayloads(boolean deliver) {
        this.addField(ConfigureNodeFields.deliver_payloads, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.deliver_payloads.getFieldName(), deliver);
    }

    public ItemReply getItemReply() {
        String value = this.getFieldValue(ConfigureNodeFields.itemreply);
        if (value == null) {
            return null;
        }
        return ItemReply.valueOf(value);
    }

    public void setItemReply(ItemReply reply) {
        this.addField(ConfigureNodeFields.itemreply, FormField.Type.list_single);
        this.setAnswer(ConfigureNodeFields.itemreply.getFieldName(), ConfigureForm.getListSingle(reply.toString()));
    }

    public int getMaxItems() {
        return Integer.parseInt(this.getFieldValue(ConfigureNodeFields.max_items));
    }

    public void setMaxItems(int max) {
        this.addField(ConfigureNodeFields.max_items, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.max_items.getFieldName(), max);
    }

    public int getMaxPayloadSize() {
        return Integer.parseInt(this.getFieldValue(ConfigureNodeFields.max_payload_size));
    }

    public void setMaxPayloadSize(int max) {
        this.addField(ConfigureNodeFields.max_payload_size, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.max_payload_size.getFieldName(), max);
    }

    public NodeType getNodeType() {
        String value = this.getFieldValue(ConfigureNodeFields.node_type);
        if (value == null) {
            return null;
        }
        return NodeType.valueOf(value);
    }

    public void setNodeType(NodeType type) {
        this.addField(ConfigureNodeFields.node_type, FormField.Type.list_single);
        this.setAnswer(ConfigureNodeFields.node_type.getFieldName(), ConfigureForm.getListSingle(type.toString()));
    }

    public boolean isNotifyConfig() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.notify_config));
    }

    public void setNotifyConfig(boolean notify) {
        this.addField(ConfigureNodeFields.notify_config, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.notify_config.getFieldName(), notify);
    }

    public boolean isNotifyDelete() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.notify_delete));
    }

    public void setNotifyDelete(boolean notify) {
        this.addField(ConfigureNodeFields.notify_delete, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.notify_delete.getFieldName(), notify);
    }

    public boolean isNotifyRetract() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.notify_retract));
    }

    public void setNotifyRetract(boolean notify) {
        this.addField(ConfigureNodeFields.notify_retract, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.notify_retract.getFieldName(), notify);
    }

    public NotificationType getNotificationType() {
        String value = this.getFieldValue(ConfigureNodeFields.notification_type);
        if (value == null) {
            return null;
        }
        return NotificationType.valueOf(value);
    }

    public void setNotificationType(NotificationType notificationType) {
        this.addField(ConfigureNodeFields.notification_type, FormField.Type.list_single);
        this.setAnswer(ConfigureNodeFields.notification_type.getFieldName(), ConfigureForm.getListSingle(notificationType.toString()));
    }

    public boolean isPersistItems() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.persist_items));
    }

    public void setPersistentItems(boolean persist) {
        this.addField(ConfigureNodeFields.persist_items, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.persist_items.getFieldName(), persist);
    }

    public boolean isPresenceBasedDelivery() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.presence_based_delivery));
    }

    public void setPresenceBasedDelivery(boolean presenceBased) {
        this.addField(ConfigureNodeFields.presence_based_delivery, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.presence_based_delivery.getFieldName(), presenceBased);
    }

    public PublishModel getPublishModel() {
        String value = this.getFieldValue(ConfigureNodeFields.publish_model);
        if (value == null) {
            return null;
        }
        return PublishModel.valueOf(value);
    }

    public void setPublishModel(PublishModel publish) {
        this.addField(ConfigureNodeFields.publish_model, FormField.Type.list_single);
        this.setAnswer(ConfigureNodeFields.publish_model.getFieldName(), ConfigureForm.getListSingle(publish.toString()));
    }

    public List<String> getReplyRoom() {
        return this.getFieldValues(ConfigureNodeFields.replyroom);
    }

    public void setReplyRoom(List<String> replyRooms) {
        this.addField(ConfigureNodeFields.replyroom, FormField.Type.list_multi);
        this.setAnswer(ConfigureNodeFields.replyroom.getFieldName(), replyRooms);
    }

    public List<String> getReplyTo() {
        return this.getFieldValues(ConfigureNodeFields.replyto);
    }

    public void setReplyTo(List<String> replyTos) {
        this.addField(ConfigureNodeFields.replyto, FormField.Type.list_multi);
        this.setAnswer(ConfigureNodeFields.replyto.getFieldName(), replyTos);
    }

    public List<String> getRosterGroupsAllowed() {
        return this.getFieldValues(ConfigureNodeFields.roster_groups_allowed);
    }

    public void setRosterGroupsAllowed(List<String> groups) {
        this.addField(ConfigureNodeFields.roster_groups_allowed, FormField.Type.list_multi);
        this.setAnswer(ConfigureNodeFields.roster_groups_allowed.getFieldName(), groups);
    }

    @Deprecated
    public boolean isSubscibe() {
        return this.isSubscribe();
    }

    public boolean isSubscribe() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.subscribe));
    }

    public void setSubscribe(boolean subscribe) {
        this.addField(ConfigureNodeFields.subscribe, FormField.Type.bool);
        this.setAnswer(ConfigureNodeFields.subscribe.getFieldName(), subscribe);
    }

    @Override
    public String getTitle() {
        return this.getFieldValue(ConfigureNodeFields.title);
    }

    @Override
    public void setTitle(String title) {
        this.addField(ConfigureNodeFields.title, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.title.getFieldName(), title);
    }

    public String getDataType() {
        return this.getFieldValue(ConfigureNodeFields.type);
    }

    public void setDataType(String type) {
        this.addField(ConfigureNodeFields.type, FormField.Type.text_single);
        this.setAnswer(ConfigureNodeFields.type.getFieldName(), type);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getName() + " Content [");
        for (FormField formField : this.getFields()) {
            result.append('(');
            result.append(formField.getVariable());
            result.append(':');
            StringBuilder valuesBuilder = new StringBuilder();
            for (CharSequence value : formField.getValues()) {
                if (valuesBuilder.length() > 0) {
                    result.append(',');
                }
                valuesBuilder.append(value);
            }
            if (valuesBuilder.length() == 0) {
                valuesBuilder.append("NOT SET");
            }
            result.append((CharSequence)valuesBuilder);
            result.append(')');
        }
        result.append(']');
        return result.toString();
    }

    private static boolean parseBoolean(String fieldValue) {
        return "1".equals(fieldValue) || "true".equals(fieldValue);
    }

    private String getFieldValue(ConfigureNodeFields field) {
        FormField formField = this.getField(field.getFieldName());
        return formField.getFirstValue();
    }

    private List<String> getFieldValues(ConfigureNodeFields field) {
        FormField formField = this.getField(field.getFieldName());
        return formField.getValuesAsString();
    }

    private void addField(ConfigureNodeFields nodeField, FormField.Type type) {
        String fieldName = nodeField.getFieldName();
        if (this.getField(fieldName) == null) {
            FormField field = FormField.builder().setVariable(fieldName).setType(type).build();
            this.addField(field);
        }
    }

    private static List<String> getListSingle(String value) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(value);
        return list;
    }
}

