/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;

public class DataFormProvider
extends ExtensionElementProvider<DataForm> {
    private static final Logger LOGGER = Logger.getLogger(DataFormProvider.class.getName());
    public static final DataFormProvider INSTANCE = new DataFormProvider();

    /*
     * Enabled aggressive block sorting
     */
    public DataForm parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        DataForm.Type dataFormType = DataForm.Type.fromString(parser.getAttributeValue("", "type"));
        DataForm dataForm = new DataForm(dataFormType);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    XmlEnvironment elementXmlEnvironment = XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment);
                    switch (name) {
                        case "instructions": {
                            dataForm.addInstruction(parser.nextText());
                            break;
                        }
                        case "title": {
                            dataForm.setTitle(parser.nextText());
                            break;
                        }
                        case "field": {
                            FormField formField = DataFormProvider.parseField(parser, elementXmlEnvironment);
                            dataForm.addField(formField);
                            break;
                        }
                        case "item": {
                            DataForm.Item item = DataFormProvider.parseItem(parser, elementXmlEnvironment);
                            dataForm.addItem(item);
                            break;
                        }
                        case "reported": {
                            DataForm.ReportedData reported = DataFormProvider.parseReported(parser, elementXmlEnvironment);
                            dataForm.setReportedData(reported);
                            break;
                        }
                        case "query": {
                            if (namespace.equals("jabber:iq:roster")) {
                                dataForm.addExtensionElement(RosterPacketProvider.INSTANCE.parse(parser));
                                break;
                            }
                            break block0;
                        }
                        case "page": {
                            if (namespace.equals("http://jabber.org/protocol/xdata-layout")) {
                                dataForm.addExtensionElement((Element)DataLayoutProvider.parse(parser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return dataForm;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FormField parseField(XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String label;
        int initialDepth = parser.getDepth();
        String var = parser.getAttributeValue("", "var");
        FormField.Type type = FormField.Type.fromString(parser.getAttributeValue("", "type"));
        FormField.Builder builder = FormField.builder();
        builder.setType(type);
        if (type != FormField.Type.fixed) {
            builder.setVariable(var);
        }
        if (StringUtils.isNotEmpty((CharSequence)(label = parser.getAttributeValue("", "label")))) {
            builder.setLabel(label);
        }
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            switch (eventType) {
                case START_ELEMENT: {
                    QName qname = parser.getQName();
                    FormFieldChildElementProvider<?> provider = FormFieldChildElementProviderManager.getFormFieldChildElementProvider(qname);
                    if (provider != null) {
                        FormFieldChildElement formFieldChildElement = (FormFieldChildElement)provider.parse(parser, XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment));
                        builder.addFormFieldChildElement(formFieldChildElement);
                        break;
                    }
                    LOGGER.warning("Unknown form field child element " + qname + " ignored");
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.Item parseItem(XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            FormField field = DataFormProvider.parseField(parser, XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment));
                            fields.add(field);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.Item(fields);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.ReportedData parseReported(XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            FormField field = DataFormProvider.parseField(parser, XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment));
                            fields.add(field);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.ReportedData(fields);
                }
            }
        }
    }
}

