/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferException;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;

public final class FileTransferNegotiator
extends Manager {
    public static final String SI_NAMESPACE = "http://jabber.org/protocol/si";
    public static final String SI_PROFILE_FILE_TRANSFER_NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer"};
    private static final Map<XMPPConnection, FileTransferNegotiator> INSTANCES = new WeakHashMap<XMPPConnection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator = new Random();
    public static boolean IBB_ONLY = System.getProperty("ibb") != null;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static synchronized FileTransferNegotiator getInstanceFor(XMPPConnection connection) {
        FileTransferNegotiator fileTransferNegotiator = INSTANCES.get(connection);
        if (fileTransferNegotiator == null) {
            fileTransferNegotiator = new FileTransferNegotiator(connection);
            INSTANCES.put(connection, fileTransferNegotiator);
        }
        return fileTransferNegotiator;
    }

    private static void setServiceEnabled(XMPPConnection connection, boolean isEnabled) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(Arrays.asList(NAMESPACE));
        namespaces.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            namespaces.add("http://jabber.org/protocol/bytestreams");
        }
        for (String namespace : namespaces) {
            if (isEnabled) {
                manager.addFeature(namespace);
                continue;
            }
            manager.removeFeature(namespace);
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(Arrays.asList(NAMESPACE));
        namespaces.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            namespaces.add("http://jabber.org/protocol/bytestreams");
        }
        for (String namespace : namespaces) {
            if (manager.includesFeature(namespace)) continue;
            return false;
        }
        return true;
    }

    public static Collection<String> getSupportedProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            protocols.add("http://jabber.org/protocol/bytestreams");
        }
        return Collections.unmodifiableList(protocols);
    }

    private FileTransferNegotiator(XMPPConnection connection) {
        super(connection);
        this.byteStreamTransferManager = new Socks5TransferNegotiator(connection);
        this.inbandTransferManager = new IBBTransferNegotiator(connection);
        FileTransferNegotiator.setServiceEnabled(connection, true);
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest request) throws SmackException.NotConnectedException, FileTransferException.NoStreamMethodsOfferedException, FileTransferException.NoAcceptableTransferMechanisms, InterruptedException {
        StreamNegotiator selectedStreamNegotiator;
        StreamInitiation si = request.getStreamInitiation();
        ListSingleFormField streamMethodField = FileTransferNegotiator.getStreamMethodField(si.getFeatureNegotiationForm());
        if (streamMethodField == null) {
            String errorMessage = "No stream methods contained in stanza.";
            StanzaError error = StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)errorMessage).build();
            ErrorIQ iqPacket = IQ.createErrorResponse((IQ)si, (StanzaError)error);
            this.connection().sendStanza((Stanza)iqPacket);
            throw new FileTransferException.NoStreamMethodsOfferedException();
        }
        try {
            selectedStreamNegotiator = this.getNegotiator(streamMethodField);
        }
        catch (FileTransferException.NoAcceptableTransferMechanisms e) {
            ErrorIQ iqPacket = IQ.createErrorResponse((IQ)si, (StanzaError)StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)"No acceptable transfer mechanism").build());
            this.connection().sendStanza((Stanza)iqPacket);
            throw e;
        }
        return selectedStreamNegotiator;
    }

    private static ListSingleFormField getStreamMethodField(DataForm form) {
        return (ListSingleFormField)form.getField(STREAM_DATA_FIELD_NAME);
    }

    private StreamNegotiator getNegotiator(ListSingleFormField field) throws FileTransferException.NoAcceptableTransferMechanisms {
        boolean isByteStream = false;
        boolean isIBB = false;
        for (FormField.Option option : field.getOptions()) {
            String variable = option.getValueString();
            if (variable.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals("http://jabber.org/protocol/ibb")) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            throw new FileTransferException.NoAcceptableTransferMechanisms();
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public static String getNextStreamID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(STREAM_INIT_PREFIX);
        buffer.append(randomGenerator.nextInt(Integer.MAX_VALUE) + randomGenerator.nextInt(Integer.MAX_VALUE));
        return buffer.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(Jid userID, String streamID, String fileName, long size, String desc, int responseTimeout) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, FileTransferException.NoAcceptableTransferMechanisms, InterruptedException {
        StreamInitiation si = new StreamInitiation();
        si.setSessionID(streamID);
        si.setMimeType(URLConnection.guessContentTypeFromName(fileName));
        StreamInitiation.File siFile = new StreamInitiation.File(fileName, size);
        siFile.setDesc(desc);
        si.setFile(siFile);
        si.setFeatureNegotiationForm(FileTransferNegotiator.createDefaultInitiationForm());
        si.setFrom((Jid)this.connection().getUser());
        si.setTo(userID);
        si.setType(IQ.Type.set);
        Stanza siResponse = this.connection().createStanzaCollectorAndSend((IQ)si).nextResultOrThrow((long)responseTimeout);
        if (siResponse instanceof IQ) {
            IQ iqResponse = (IQ)siResponse;
            if (iqResponse.getType().equals((Object)IQ.Type.result)) {
                StreamInitiation response = (StreamInitiation)siResponse;
                return this.getOutgoingNegotiator(FileTransferNegotiator.getStreamMethodField(response.getFeatureNegotiationForm()));
            }
            throw new XMPPException.XMPPErrorException((Stanza)iqResponse, iqResponse.getError());
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField field) throws FileTransferException.NoAcceptableTransferMechanisms {
        boolean isByteStream = false;
        boolean isIBB = false;
        for (CharSequence charSequence : field.getValues()) {
            String variableString = charSequence.toString();
            if (variableString.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variableString.equals("http://jabber.org/protocol/ibb")) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            throw new FileTransferException.NoAcceptableTransferMechanisms();
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private static DataForm createDefaultInitiationForm() {
        DataForm.Builder form = DataForm.builder().setType(DataForm.Type.form);
        ListSingleFormField.Builder fieldBuilder = FormField.listSingleBuilder(STREAM_DATA_FIELD_NAME);
        if (!IBB_ONLY) {
            fieldBuilder.addOption("http://jabber.org/protocol/bytestreams");
        }
        fieldBuilder.addOption("http://jabber.org/protocol/ibb");
        form.addField(fieldBuilder.build());
        return form.build();
    }
}

