/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.formtypes;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FormFieldRegistry {
    private static final Map<String, Map<String, FormField.Type>> REGISTRY = new HashMap<String, Map<String, FormField.Type>>();
    private static final Map<String, FormField.Type> LOOKASIDE_REGISTRY = new HashMap<String, FormField.Type>();
    private static final Map<String, String> FIELD_NAME_TO_FORM_TYPE = new HashMap<String, String>();

    public static synchronized void register(DataForm dataForm) {
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        String formType = null;
        TextSingleFormField hiddenFormTypeField = dataForm.getHiddenFormTypeField();
        if (hiddenFormTypeField != null) {
            formType = hiddenFormTypeField.getValue();
        }
        for (FormField formField : dataForm.getFields()) {
            if (formField == hiddenFormTypeField) continue;
            String fieldName = formField.getFieldName();
            FormField.Type type = formField.getType();
            FormFieldRegistry.register(formType, fieldName, type);
        }
    }

    public static synchronized void register(String formType, String fieldName, FormField.Type type) {
        if (formType == null) {
            FormFieldInformation formFieldInformation = FormFieldRegistry.lookup(fieldName);
            if (formFieldInformation != null) {
                if (Objects.equals((Object)formType, (Object)formFieldInformation.formType) && type.equals((Object)formFieldInformation.formFieldType)) {
                    return;
                }
                String message = "There is already a field with the name'" + fieldName + "' registered with the field type '" + (Object)((Object)formFieldInformation.formFieldType) + "', while this tries to register the field with the type '" + (Object)((Object)type) + '\'';
                throw new IllegalArgumentException(message);
            }
            LOOKASIDE_REGISTRY.put(fieldName, type);
            return;
        }
        Map<String, FormField.Type> fieldNameToType = REGISTRY.get(formType);
        if (fieldNameToType == null) {
            fieldNameToType = new HashMap<String, FormField.Type>();
            REGISTRY.put(formType, fieldNameToType);
        } else {
            FormField.Type previousType = fieldNameToType.get(fieldName);
            if (previousType != null && previousType != type) {
                throw new IllegalArgumentException();
            }
        }
        fieldNameToType.put(fieldName, type);
        FIELD_NAME_TO_FORM_TYPE.put(fieldName, formType);
    }

    public static synchronized void register(String fieldName, FormField.Type type) {
        FormField.Type previousType = LOOKASIDE_REGISTRY.get(fieldName);
        if (previousType != null) {
            if (previousType == type) {
                return;
            }
            throw new IllegalArgumentException("There is already a field with the name '" + fieldName + "' registered with type " + (Object)((Object)previousType) + ", while trying to register this field with type '" + (Object)((Object)type) + "'");
        }
        LOOKASIDE_REGISTRY.put(fieldName, type);
    }

    public static synchronized FormField.Type lookup(String formType, String fieldName) {
        if (formType != null) {
            FormField.Type type;
            Map<String, FormField.Type> fieldNameToTypeMap = REGISTRY.get(formType);
            if (fieldNameToTypeMap != null && (type = fieldNameToTypeMap.get(fieldName)) != null) {
                return type;
            }
        } else {
            FormField.Type type;
            formType = FIELD_NAME_TO_FORM_TYPE.get(fieldName);
            if (formType != null && (type = FormFieldRegistry.lookup(formType, fieldName)) != null) {
                return type;
            }
        }
        return LOOKASIDE_REGISTRY.get(fieldName);
    }

    public static synchronized FormFieldInformation lookup(String fieldName) {
        String formType = FIELD_NAME_TO_FORM_TYPE.get(fieldName);
        FormField.Type type = FormFieldRegistry.lookup(formType, fieldName);
        if (type == null) {
            return null;
        }
        return new FormFieldInformation(type, formType);
    }

    static {
        FormFieldRegistry.register("FORM_TYPE", FormField.Type.hidden);
    }

    public static final class FormFieldInformation {
        public final FormField.Type formFieldType;
        public final String formType;

        private FormFieldInformation(FormField.Type formFieldType, String formType) {
            this.formFieldType = formFieldType;
            this.formType = formType;
        }
    }
}

