/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.SingleValueFormField;

public class BooleanFormField
extends SingleValueFormField {
    private final Boolean value;

    protected BooleanFormField(Builder builder) {
        super(builder);
        this.value = builder.value;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public Boolean getValueAsBoolean() {
        return this.value;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends FormField.Builder<BooleanFormField, Builder> {
        private Boolean value;

        private Builder(BooleanFormField booleanFormField) {
            super(booleanFormField);
            this.value = booleanFormField.value;
        }

        Builder(String fieldName) {
            super(fieldName, FormField.Type.bool);
        }

        @Override
        protected void resetInternal() {
            this.value = null;
        }

        @Deprecated
        public Builder addValue(CharSequence value) {
            return this.setValue(value);
        }

        public Builder setValue(CharSequence value) {
            boolean valueBoolean = ParserUtils.parseXmlBoolean((String)value.toString());
            return this.setValue(valueBoolean);
        }

        public Builder setValue(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public BooleanFormField build() {
            return new BooleanFormField(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

