/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Exception;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.ExpirationCache;

public class Socks5BytestreamRequest
implements BytestreamRequest {
    private static final long BLACKLIST_LIFETIME = 0x6DDD00L;
    private static final int BLACKLIST_MAX_SIZE = 100;
    private static final Cache<String, Integer> ADDRESS_BLACKLIST = new ExpirationCache(100, 0x6DDD00L);
    private static int DEFAULT_CONNECTION_FAILURE_THRESHOLD = 2;
    private int connectionFailureThreshold = DEFAULT_CONNECTION_FAILURE_THRESHOLD;
    private Bytestream bytestreamRequest;
    private Socks5BytestreamManager manager;
    private int totalConnectTimeout = 10000;
    private int minimumConnectTimeout = 2000;

    public static int getDefaultConnectFailureThreshold() {
        return DEFAULT_CONNECTION_FAILURE_THRESHOLD;
    }

    public static void setDefaultConnectFailureThreshold(int defaultConnectFailureThreshold) {
        DEFAULT_CONNECTION_FAILURE_THRESHOLD = defaultConnectFailureThreshold;
    }

    public int getConnectFailureThreshold() {
        return this.connectionFailureThreshold;
    }

    public void setConnectFailureThreshold(int connectFailureThreshold) {
        this.connectionFailureThreshold = connectFailureThreshold;
    }

    protected Socks5BytestreamRequest(Socks5BytestreamManager manager, Bytestream bytestreamRequest) {
        this.manager = manager;
        this.bytestreamRequest = bytestreamRequest;
    }

    public int getTotalConnectTimeout() {
        if (this.totalConnectTimeout <= 0) {
            return 10000;
        }
        return this.totalConnectTimeout;
    }

    public void setTotalConnectTimeout(int totalConnectTimeout) {
        this.totalConnectTimeout = totalConnectTimeout;
    }

    public int getMinimumConnectTimeout() {
        if (this.minimumConnectTimeout <= 0) {
            return 2000;
        }
        return this.minimumConnectTimeout;
    }

    public void setMinimumConnectTimeout(int minimumConnectTimeout) {
        this.minimumConnectTimeout = minimumConnectTimeout;
    }

    @Override
    public Jid getFrom() {
        return this.bytestreamRequest.getFrom();
    }

    @Override
    public String getSessionID() {
        return this.bytestreamRequest.getSessionID();
    }

    @Override
    public Socks5BytestreamSession accept() throws InterruptedException, XMPPException.XMPPErrorException, Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host, SmackException.NotConnectedException, Socks5Exception.NoSocks5StreamHostsProvided {
        List<Bytestream.StreamHost> streamHosts = this.bytestreamRequest.getStreamHosts();
        HashMap<Bytestream.StreamHost, Exception> streamHostsExceptions = new HashMap<Bytestream.StreamHost, Exception>();
        if (streamHosts.size() == 0) {
            this.cancelRequest(streamHostsExceptions);
        }
        Bytestream.StreamHost selectedHost = null;
        Socket socket = null;
        String digest = Socks5Utils.createDigest(this.bytestreamRequest.getSessionID(), this.bytestreamRequest.getFrom(), (Jid)this.manager.getConnection().getUser());
        int timeout = Math.max(this.getTotalConnectTimeout() / streamHosts.size(), this.getMinimumConnectTimeout());
        for (Bytestream.StreamHost streamHost : streamHosts) {
            String address = streamHost.getAddress() + ":" + streamHost.getPort();
            int failures = Socks5BytestreamRequest.getConnectionFailures(address);
            if (this.connectionFailureThreshold > 0 && failures >= this.connectionFailureThreshold) continue;
            try {
                Socks5Client socks5Client = new Socks5Client(streamHost, digest);
                socket = socks5Client.getSocket(timeout);
                selectedHost = streamHost;
                break;
            }
            catch (IOException | TimeoutException | SmackException | XMPPException e) {
                streamHostsExceptions.put(streamHost, (Exception)e);
                Socks5BytestreamRequest.incrementConnectionFailures(address);
            }
        }
        if (selectedHost == null || socket == null) {
            this.cancelRequest(streamHostsExceptions);
        }
        Bytestream response = this.createUsedHostResponse(selectedHost);
        this.manager.getConnection().sendStanza((Stanza)response);
        return new Socks5BytestreamSession(socket, selectedHost.getJID().equals((CharSequence)this.bytestreamRequest.getFrom()));
    }

    @Override
    public void reject() throws SmackException.NotConnectedException, InterruptedException {
        this.manager.replyRejectPacket(this.bytestreamRequest);
    }

    private void cancelRequest(Map<Bytestream.StreamHost, Exception> streamHostsExceptions) throws SmackException.NotConnectedException, InterruptedException, Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host, Socks5Exception.NoSocks5StreamHostsProvided {
        String errorMessage;
        Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host couldNotConnectException;
        Socks5Exception.NoSocks5StreamHostsProvided noHostsProvidedException;
        if (streamHostsExceptions.isEmpty()) {
            noHostsProvidedException = new Socks5Exception.NoSocks5StreamHostsProvided();
            couldNotConnectException = null;
            errorMessage = noHostsProvidedException.getMessage();
        } else {
            noHostsProvidedException = null;
            couldNotConnectException = Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host.construct(streamHostsExceptions);
            errorMessage = couldNotConnectException.getMessage();
        }
        StanzaError error = StanzaError.from((StanzaError.Condition)StanzaError.Condition.item_not_found, (String)errorMessage).build();
        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)this.bytestreamRequest, (StanzaError)error);
        this.manager.getConnection().sendStanza((Stanza)errorIQ);
        if (noHostsProvidedException != null) {
            throw noHostsProvidedException;
        }
        throw couldNotConnectException;
    }

    private Bytestream createUsedHostResponse(Bytestream.StreamHost selectedHost) {
        Bytestream response = new Bytestream(this.bytestreamRequest.getSessionID());
        response.setTo(this.bytestreamRequest.getFrom());
        response.setType(IQ.Type.result);
        response.setStanzaId(this.bytestreamRequest.getStanzaId());
        response.setUsedHost(selectedHost.getJID());
        return response;
    }

    private static void incrementConnectionFailures(String address) {
        Integer count = (Integer)ADDRESS_BLACKLIST.lookup((Object)address);
        ADDRESS_BLACKLIST.put((Object)address, (Object)(count == null ? 1 : count + 1));
    }

    private static int getConnectionFailures(String address) {
        Integer count = (Integer)ADDRESS_BLACKLIST.lookup((Object)address);
        return count != null ? count : 0;
    }
}

