/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.jivesoftware.smackx.jingle.element.UnknownJingleContentDescription;
import org.jivesoftware.smackx.jingle.element.UnknownJingleContentTransport;
import org.jivesoftware.smackx.jingle.provider.JingleContentProviderManager;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.FullJid;

public class JingleProvider
extends IqProvider<Jingle> {
    private static final Logger LOGGER = Logger.getLogger(JingleProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public Jingle parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        Jingle.Builder builder = Jingle.builder(iqData);
        String actionString = parser.getAttributeValue("", "action");
        if (actionString != null) {
            JingleAction action = JingleAction.fromString(actionString);
            builder.setAction(action);
        }
        EntityFullJid initiator = ParserUtils.getFullJidAttribute((XmlPullParser)parser, (String)"initiator");
        builder.setInitiator((FullJid)initiator);
        EntityFullJid responder = ParserUtils.getFullJidAttribute((XmlPullParser)parser, (String)"responder");
        builder.setResponder((FullJid)responder);
        String sessionId = parser.getAttributeValue("", "sid");
        builder.setSessionId(sessionId);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String tagName;
                    switch (tagName = parser.getName()) {
                        case "content": {
                            JingleContent content = JingleProvider.parseJingleContent(parser, parser.getDepth());
                            builder.addJingleContent(content);
                            break block0;
                        }
                        case "reason": {
                            JingleReason reason;
                            parser.next();
                            String reasonString = parser.getName();
                            if (reasonString.equals("alternative-session")) {
                                parser.next();
                                String sid = parser.nextText();
                                reason = new JingleReason.AlternativeSession(sid);
                            } else {
                                reason = new JingleReason(JingleReason.Reason.fromString(reasonString));
                            }
                            builder.setReason(reason);
                            break block0;
                        }
                    }
                    LOGGER.severe("Unknown Jingle element: " + tagName);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JingleContent parseJingleContent(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackParsingException {
        JingleContent.Builder builder = JingleContent.getBuilder();
        String creatorString = parser.getAttributeValue("", "creator");
        JingleContent.Creator creator = JingleContent.Creator.valueOf(creatorString);
        builder.setCreator(creator);
        String disposition = parser.getAttributeValue("", "disposition");
        builder.setDisposition(disposition);
        String name = parser.getAttributeValue("", "name");
        builder.setName(name);
        String sendersString = parser.getAttributeValue("", "senders");
        if (sendersString != null) {
            JingleContent.Senders senders = JingleContent.Senders.valueOf(sendersString);
            builder.setSenders(senders);
        }
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String tagName = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (tagName) {
                        case "description": {
                            JingleContentDescription description;
                            StandardExtensionElement standardExtensionElement;
                            ExtensionElementProvider provider = JingleContentProviderManager.getJingleContentDescriptionProvider(namespace);
                            if (provider == null) {
                                standardExtensionElement = (StandardExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(parser);
                                description = new UnknownJingleContentDescription(standardExtensionElement);
                            } else {
                                description = (JingleContentDescription)provider.parse(parser);
                            }
                            builder.setDescription(description);
                            break block0;
                        }
                        case "transport": {
                            JingleContentTransport transport;
                            StandardExtensionElement standardExtensionElement;
                            ExtensionElementProvider provider = JingleContentProviderManager.getJingleContentTransportProvider(namespace);
                            if (provider == null) {
                                standardExtensionElement = (StandardExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(parser);
                                transport = new UnknownJingleContentTransport(standardExtensionElement);
                            } else {
                                transport = (JingleContentTransport)provider.parse(parser);
                            }
                            builder.setTransport(transport);
                            break block0;
                        }
                    }
                    LOGGER.severe("Unknown Jingle content element: " + tagName);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }
}

