/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareinfo.form;

import java.util.List;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FilledForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class SoftwareInfoForm
extends FilledForm {
    public static final String FORM_TYPE = "urn:xmpp:dataforms:softwareinfo";
    public static final String OS = "os";
    public static final String OS_VERSION = "os_version";
    public static final String SOFTWARE = "software";
    public static final String SOFTWARE_VERSION = "software_version";
    public static final String ICON = "icon";

    private SoftwareInfoForm(DataForm dataForm) {
        super(dataForm);
    }

    public String getOS() {
        return this.readFirstValue(OS);
    }

    public String getOSVersion() {
        return this.readFirstValue(OS_VERSION);
    }

    public String getSoftwareName() {
        return this.readFirstValue(SOFTWARE);
    }

    public String getSoftwareVersion() {
        return this.readFirstValue(SOFTWARE_VERSION);
    }

    public MediaElement getIcon() {
        FormField field = this.getField(ICON);
        if (field == null) {
            return null;
        }
        FormFieldChildElement media = field.getFormFieldChildElement(MediaElement.QNAME);
        if (media == null) {
            return null;
        }
        return (MediaElement)media;
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals((Object)this, (Object)obj, (equalsBuilder, otherObj) -> equalsBuilder.append((Object)this.getDataForm().getType(), (Object)otherObj.getDataForm().getType()).append((Object)this.getDataForm().getTitle(), (Object)otherObj.getDataForm().getTitle()).append((Object)this.getDataForm().getReportedData(), (Object)otherObj.getDataForm().getReportedData()).append(this.getDataForm().getItems(), otherObj.getDataForm().getItems()).append(this.getDataForm().getFields(), otherObj.getDataForm().getFields()).append(this.getDataForm().getExtensionElements(), otherObj.getDataForm().getExtensionElements()));
    }

    public int hashCode() {
        HashCode.Builder builder = HashCode.builder();
        builder.append(this.getDataForm().getFields());
        builder.append(this.getDataForm().getItems());
        builder.append(this.getDataForm().getExtensionElements());
        return builder.build();
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        DataForm.Builder dataFormBuilder = DataForm.builder(DataForm.Type.result);

        private Builder() {
            TextSingleFormField formField = FormField.buildHiddenFormType(SoftwareInfoForm.FORM_TYPE);
            this.dataFormBuilder.addField(formField);
        }

        public Builder setIcon(int height, int width, List<MediaElement.Uri> uriList) {
            MediaElement.Builder mediaBuilder = MediaElement.builder();
            for (MediaElement.Uri uri : uriList) {
                mediaBuilder.addUri(uri);
            }
            MediaElement mediaElement = mediaBuilder.setHeightAndWidth(height, width).build();
            return this.setIcon(mediaElement);
        }

        public Builder setIcon(MediaElement mediaElement) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.ICON);
            builder.addFormFieldChildElement(mediaElement);
            this.dataFormBuilder.addField((FormField)builder.build());
            return this;
        }

        public Builder setOS(String os) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.OS);
            builder.setValue(os);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public Builder setOSVersion(String os_version) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.OS_VERSION);
            builder.setValue(os_version);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public Builder setSoftware(String software) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.SOFTWARE);
            builder.setValue(software);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public Builder setSoftwareVersion(String softwareVersion) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.SOFTWARE_VERSION);
            builder.setValue(softwareVersion);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public Builder setDataForm(DataForm dataForm) {
            if (dataForm.getTitle() != null || !dataForm.getItems().isEmpty() || dataForm.getReportedData() != null || !dataForm.getInstructions().isEmpty()) {
                throw new IllegalArgumentException("Illegal Arguements for SoftwareInformation");
            }
            String formTypeValue = dataForm.getFormType();
            if (formTypeValue == null) {
                throw new IllegalArgumentException("FORM_TYPE Formfield missing");
            }
            if (!formTypeValue.equals(SoftwareInfoForm.FORM_TYPE)) {
                throw new IllegalArgumentException("Malformed FORM_TYPE Formfield encountered");
            }
            this.dataFormBuilder = dataForm.asBuilder();
            return this;
        }

        public SoftwareInfoForm build() {
            return new SoftwareInfoForm(this.dataFormBuilder.build());
        }
    }
}

