/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.CloseListener;
import org.jivesoftware.smackx.bytestreams.ibb.DataListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InitiationListener;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jxmpp.jid.Jid;

public final class InBandBytestreamManager
extends Manager
implements BytestreamManager {
    public static final int MAXIMUM_BLOCK_SIZE = 65535;
    private static final String SESSION_ID_PREFIX = "jibb_";
    private static final Map<XMPPConnection, InBandBytestreamManager> managers;
    private final Map<Jid, BytestreamListener> userListeners = new ConcurrentHashMap<Jid, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private final DataListener dataListener;
    private final CloseListener closeListener;
    private final Map<String, InBandBytestreamSession> sessions = new ConcurrentHashMap<String, InBandBytestreamSession>();
    private int defaultBlockSize = 4096;
    private int maximumBlockSize = 65535;
    private StanzaType stanza = StanzaType.IQ;
    private final List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized InBandBytestreamManager getByteStreamManager(XMPPConnection connection) {
        if (connection == null) {
            return null;
        }
        InBandBytestreamManager manager = managers.get(connection);
        if (manager == null) {
            manager = new InBandBytestreamManager(connection);
            managers.put(connection, manager);
        }
        return manager;
    }

    private InBandBytestreamManager(XMPPConnection connection) {
        super(connection);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

            public void connectionTerminated() {
                InBandBytestreamManager.this.sessions.clear();
                InBandBytestreamManager.this.ignoredBytestreamRequests.clear();
            }
        });
        this.initiationListener = new InitiationListener(this);
        connection.registerIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.dataListener = new DataListener(this);
        connection.registerIQRequestHandler((IQRequestHandler)this.dataListener);
        this.closeListener = new CloseListener(this);
        connection.registerIQRequestHandler((IQRequestHandler)this.closeListener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.add(listener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.remove(listener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener, Jid initiatorJID) {
        this.userListeners.put(initiatorJID, listener);
    }

    @Override
    public void removeIncomingBytestreamListener(Jid initiatorJID) {
        this.userListeners.remove(initiatorJID);
    }

    public void ignoreBytestreamRequestOnce(String sessionID) {
        this.ignoredBytestreamRequests.add(sessionID);
    }

    public int getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public void setDefaultBlockSize(int defaultBlockSize) {
        if (defaultBlockSize <= 0 || defaultBlockSize > 65535) {
            throw new IllegalArgumentException("Default block size must be between 1 and 65535");
        }
        this.defaultBlockSize = defaultBlockSize;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public void setMaximumBlockSize(int maximumBlockSize) {
        if (maximumBlockSize <= 0 || maximumBlockSize > 65535) {
            throw new IllegalArgumentException("Maximum block size must be between 1 and 65535");
        }
        this.maximumBlockSize = maximumBlockSize;
    }

    public StanzaType getStanza() {
        return this.stanza;
    }

    public void setStanza(StanzaType stanza) {
        this.stanza = stanza;
    }

    @Override
    public InBandBytestreamSession establishSession(Jid targetJID) throws XMPPException, SmackException, InterruptedException {
        String sessionID = InBandBytestreamManager.getNextSessionID();
        return this.establishSession(targetJID, sessionID);
    }

    @Override
    public InBandBytestreamSession establishSession(Jid targetJID, String sessionID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Open byteStreamRequest = new Open(sessionID, this.defaultBlockSize, this.stanza);
        byteStreamRequest.setTo(targetJID);
        XMPPConnection connection = this.connection();
        connection.sendIqRequestAndWaitForResponse((IQ)byteStreamRequest);
        InBandBytestreamSession inBandBytestreamSession = new InBandBytestreamSession(connection, byteStreamRequest, targetJID);
        this.sessions.put(sessionID, inBandBytestreamSession);
        return inBandBytestreamSession;
    }

    void replyRejectPacket(IQ request) throws SmackException.NotConnectedException, InterruptedException {
        ErrorIQ error = IQ.createErrorResponse((IQ)request, (StanzaError.Condition)StanzaError.Condition.not_acceptable);
        this.connection().sendStanza((Stanza)error);
    }

    void replyItemNotFoundPacket(IQ request) throws SmackException.NotConnectedException, InterruptedException {
        ErrorIQ error = IQ.createErrorResponse((IQ)request, (StanzaError.Condition)StanzaError.Condition.item_not_found);
        this.connection().sendStanza((Stanza)error);
    }

    private static String getNextSessionID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SESSION_ID_PREFIX);
        buffer.append(StringUtils.secureOnlineAttackSafeRandomString());
        return buffer.toString();
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    BytestreamListener getUserListener(Jid initiator) {
        return this.userListeners.get(initiator);
    }

    List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    Map<String, InBandBytestreamSession> getSessions() {
        return this.sessions;
    }

    List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                InBandBytestreamManager.getByteStreamManager(connection);
            }
        });
        managers = new WeakHashMap<XMPPConnection, InBandBytestreamManager>();
    }

    public static enum StanzaType {
        IQ,
        MESSAGE;

    }
}

