/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands.packet;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataView;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class AdHocCommandDataBuilder
extends IqBuilder<AdHocCommandDataBuilder, AdHocCommandData>
implements AdHocCommandDataView {
    private final String node;
    private String name;
    private String sessionId;
    private final List<AdHocCommandNote> notes = new ArrayList<AdHocCommandNote>();
    private DataForm form;
    private AdHocCommandData.Action action;
    private AdHocCommandData.Status status;
    private final Set<AdHocCommandData.AllowedAction> actions = EnumSet.noneOf(AdHocCommandData.AllowedAction.class);
    private AdHocCommandData.AllowedAction executeAction;

    AdHocCommandDataBuilder(String node, IqData iqCommon) {
        super((AbstractIqBuilder)iqCommon);
        this.node = (String)StringUtils.requireNotNullNorEmpty((CharSequence)node, (String)"Ad-Hoc Command node must be set");
    }

    AdHocCommandDataBuilder(String node, String stanzaId) {
        super(stanzaId);
        this.node = (String)StringUtils.requireNotNullNorEmpty((CharSequence)node, (String)"Ad-Hoc Command node must be set");
    }

    AdHocCommandDataBuilder(String node, XMPPConnection connection) {
        super(connection);
        this.node = (String)StringUtils.requireNotNullNorEmpty((CharSequence)node, (String)"Ad-Hoc Command node must be set");
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AdHocCommandDataBuilder setName(String name) {
        this.name = name;
        return this.getThis();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public AdHocCommandDataBuilder setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this.getThis();
    }

    @Override
    public List<AdHocCommandNote> getNotes() {
        return this.notes;
    }

    public AdHocCommandDataBuilder addNote(AdHocCommandNote note) {
        this.notes.add(note);
        return this.getThis();
    }

    @Override
    public DataForm getForm() {
        return this.form;
    }

    public AdHocCommandDataBuilder setForm(DataForm form) {
        this.form = form;
        return this.getThis();
    }

    @Override
    public AdHocCommandData.Action getAction() {
        return this.action;
    }

    public AdHocCommandDataBuilder setAction(AdHocCommandData.Action action) {
        this.action = action;
        return this.getThis();
    }

    @Override
    public AdHocCommandData.Status getStatus() {
        return this.status;
    }

    public AdHocCommandDataBuilder setStatus(AdHocCommandData.Status status) {
        this.status = status;
        return this.getThis();
    }

    public AdHocCommandDataBuilder setStatusCompleted() {
        return this.setStatus(AdHocCommandData.Status.completed);
    }

    public AdHocCommandDataBuilder setStatusExecuting(PreviousStage previousStage, NextStage nextStage) {
        this.setStatus(AdHocCommandData.Status.executing);
        switch (previousStage) {
            case exists: {
                this.addAction(AdHocCommandData.AllowedAction.prev);
                break;
            }
        }
        this.setExecuteAction(AdHocCommandData.AllowedAction.next);
        switch (nextStage) {
            case isFinal: {
                this.addAction(AdHocCommandData.AllowedAction.complete);
                this.setExecuteAction(AdHocCommandData.AllowedAction.complete);
            }
            case nonFinal: {
                this.addAction(AdHocCommandData.AllowedAction.next);
            }
        }
        return this.getThis();
    }

    @Override
    public Set<AdHocCommandData.AllowedAction> getActions() {
        return this.actions;
    }

    public AdHocCommandDataBuilder addAction(AdHocCommandData.AllowedAction action) {
        this.actions.add(action);
        return this.getThis();
    }

    @Override
    public AdHocCommandData.AllowedAction getExecuteAction() {
        return this.executeAction;
    }

    public AdHocCommandDataBuilder setExecuteAction(AdHocCommandData.AllowedAction action) {
        this.executeAction = action;
        return this.getThis();
    }

    public AdHocCommandData build() {
        return new AdHocCommandData(this);
    }

    public AdHocCommandDataBuilder getThis() {
        return this;
    }

    public static AdHocCommandDataBuilder buildResponseFor(AdHocCommandData request) {
        return AdHocCommandDataBuilder.buildResponseFor(request, IQ.ResponseType.result);
    }

    public static AdHocCommandDataBuilder buildResponseFor(AdHocCommandData request, IQ.ResponseType responseType) {
        AdHocCommandDataBuilder builder = new AdHocCommandDataBuilder(request.getNode(), AbstractIqBuilder.createResponse((IqView)request, (IQ.ResponseType)responseType));
        return builder;
    }

    public static enum NextStage {
        isFinal,
        nonFinal;

    }

    public static enum PreviousStage {
        exists,
        none;

    }
}

