/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.SpecificErrorCondition;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataBuilder;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;

public class AdHocCommandDataProvider
extends IqProvider<AdHocCommandData> {
    /*
     * Enabled aggressive block sorting
     */
    public AdHocCommandData parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String commandNode = parser.getAttributeValue("node");
        AdHocCommandDataBuilder builder = AdHocCommandData.builder(commandNode, iqData);
        DataFormProvider dataFormProvider = new DataFormProvider();
        String sessionId = parser.getAttributeValue("sessionid");
        builder.setSessionId(sessionId);
        String status = parser.getAttributeValue("", "status");
        if (AdHocCommandData.Status.executing.toString().equalsIgnoreCase(status)) {
            builder.setStatus(AdHocCommandData.Status.executing);
        } else if (AdHocCommandData.Status.completed.toString().equalsIgnoreCase(status)) {
            builder.setStatus(AdHocCommandData.Status.completed);
        } else if (AdHocCommandData.Status.canceled.toString().equalsIgnoreCase(status)) {
            builder.setStatus(AdHocCommandData.Status.canceled);
        }
        String action = parser.getAttributeValue("", "action");
        if (action != null) {
            AdHocCommandData.Action realAction = AdHocCommandData.Action.valueOf(action);
            if (realAction == null) {
                throw new SmackParsingException("Invalid value for action attribute: " + action);
            }
            builder.setAction(realAction);
        }
        while (true) {
            XmlPullParser.Event event = parser.next();
            String namespace = parser.getNamespace();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String elementName;
                    switch (elementName = parser.getName()) {
                        case "actions": {
                            String execute = parser.getAttributeValue("execute");
                            if (execute != null) {
                                builder.setExecuteAction(AdHocCommandData.AllowedAction.valueOf(execute));
                                break;
                            }
                            break block0;
                        }
                        case "next": {
                            builder.addAction(AdHocCommandData.AllowedAction.next);
                            break;
                        }
                        case "complete": {
                            builder.addAction(AdHocCommandData.AllowedAction.complete);
                            break;
                        }
                        case "prev": {
                            builder.addAction(AdHocCommandData.AllowedAction.prev);
                            break;
                        }
                        case "x": {
                            if (namespace.equals("jabber:x:data")) {
                                DataForm form = (DataForm)dataFormProvider.parse(parser);
                                builder.setForm(form);
                                break;
                            }
                            break block0;
                        }
                        case "note": {
                            String typeString = parser.getAttributeValue("type");
                            AdHocCommandNote.Type type = typeString != null ? AdHocCommandNote.Type.valueOf(typeString) : AdHocCommandNote.Type.info;
                            String value = parser.nextText();
                            builder.addNote(new AdHocCommandNote(type, value));
                            break;
                        }
                        case "error": {
                            StanzaError error = PacketParserUtils.parseError((XmlPullParser)parser);
                            builder.setError(error);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (!parser.getName().equals("command")) break;
                    return builder.build();
                }
            }
        }
    }

    public static class SessionExpiredError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        public AdHocCommandData.SpecificError parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(SpecificErrorCondition.sessionExpired);
        }
    }

    public static class BadSessionIDError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        public AdHocCommandData.SpecificError parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(SpecificErrorCondition.badSessionid);
        }
    }

    public static class BadPayloadError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        public AdHocCommandData.SpecificError parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(SpecificErrorCondition.badPayload);
        }
    }

    public static class BadLocaleError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        public AdHocCommandData.SpecificError parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(SpecificErrorCondition.badLocale);
        }
    }

    public static class MalformedActionError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        public AdHocCommandData.SpecificError parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(SpecificErrorCondition.malformedAction);
        }
    }

    public static class BadActionError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        public AdHocCommandData.SpecificError parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(SpecificErrorCondition.badAction);
        }
    }
}

