/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.geoloc.provider.GeoLocationProvider;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jxmpp.jid.Jid;

public final class GeoLocationManager
extends Manager {
    public static final String GEOLOCATION_NODE = "http://jabber.org/protocol/geoloc";
    private static final Map<XMPPConnection, GeoLocationManager> INSTANCES = new WeakHashMap<XMPPConnection, GeoLocationManager>();
    private final PepManager pepManager;

    public static synchronized GeoLocationManager getInstanceFor(XMPPConnection connection) {
        GeoLocationManager geoLocationManager = INSTANCES.get(connection);
        if (geoLocationManager == null) {
            geoLocationManager = new GeoLocationManager(connection);
            INSTANCES.put(connection, geoLocationManager);
        }
        return geoLocationManager;
    }

    private GeoLocationManager(XMPPConnection connection) {
        super(connection);
        this.pepManager = PepManager.getInstanceFor(connection);
    }

    public void sendGeoLocationToJid(GeoLocation geoLocation, Jid jid) throws InterruptedException, SmackException.NotConnectedException {
        XMPPConnection connection = this.connection();
        Message geoLocationMessage = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(jid)).addExtension((XmlElement)geoLocation)).build();
        connection.sendStanza((Stanza)geoLocationMessage);
    }

    public static boolean isGeoLocationMessage(Message message) {
        return GeoLocation.from(message) != null;
    }

    public void publishGeoLocation(GeoLocation geoLocation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException {
        this.pepManager.publish(GEOLOCATION_NODE, new PayloadItem<GeoLocation>(geoLocation));
    }

    public void stopPublishingGeolocation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException {
        this.pepManager.publish(GEOLOCATION_NODE, new PayloadItem<GeoLocation>(GeoLocation.EMPTY_GEO_LOCATION));
    }

    public boolean addGeoLocationListener(PepEventListener<GeoLocation> listener) {
        return this.pepManager.addPepEventListener(GEOLOCATION_NODE, GeoLocation.class, listener);
    }

    public boolean removeGeoLocationListener(PepEventListener<GeoLocation> listener) {
        return this.pepManager.removePepEventListener(listener);
    }

    static {
        FormFieldChildElementProviderManager.addFormFieldChildElementProvider(GeoLocationProvider.GeoLocationFormFieldChildElementProvider.INSTANCE);
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                GeoLocationManager.getInstanceFor(connection);
            }
        });
    }
}

