/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.urldata.element;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.urldata.http.element.CookieElement;
import org.jivesoftware.smackx.urldata.http.element.HeaderElement;
import org.jivesoftware.smackx.urldata.http.element.HttpAuthElement;

public class UrlDataElement
implements ExtensionElement {
    public static final String ELEMENT = "url-data";
    public static final String NAMESPACE = "http://jabber.org/protocol/url-data";
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_SID = "sid";
    public static final String XMLNS_HTTP = "xmlns:http";
    public static final String SCHEME_HTTP = "http://jabber.org/protocol/url-data/scheme/http";
    private final String target;
    private final String sid;
    private final List<HttpAuthElement> authParamElements = new ArrayList<HttpAuthElement>();
    private final List<CookieElement> cookieElements = new ArrayList<CookieElement>();
    private final List<HeaderElement> headerElements = new ArrayList<HeaderElement>();

    public UrlDataElement(String target, String sid) {
        this(target, sid, null, null, null);
    }

    public UrlDataElement(String target, String sid, List<HttpAuthElement> authParamElements, List<CookieElement> cookieElements, List<HeaderElement> headerElements) {
        this.target = target;
        this.sid = sid;
        if (authParamElements != null) {
            this.authParamElements.addAll(authParamElements);
        }
        if (cookieElements != null) {
            this.cookieElements.addAll(cookieElements);
        }
        if (headerElements != null) {
            this.headerElements.addAll(headerElements);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String getSid() {
        return this.sid;
    }

    public List<HttpAuthElement> getAuthParameters() {
        return this.authParamElements;
    }

    public List<CookieElement> getCookies() {
        return this.cookieElements;
    }

    public List<HeaderElement> getHeaders() {
        return this.headerElements;
    }

    private List<NamedElement> getMetaInformationElements() {
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        elements.addAll(this.getAuthParameters());
        elements.addAll(this.getCookies());
        elements.addAll(this.getHeaders());
        return elements;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        List<NamedElement> metaInformation = this.getMetaInformationElements();
        XmlStringBuilder sb = new XmlStringBuilder((XmlElement)this);
        if (!metaInformation.isEmpty()) {
            sb.attribute(XMLNS_HTTP, SCHEME_HTTP);
        }
        sb.attribute(ATTR_TARGET, this.getTarget()).optAttribute(ATTR_SID, this.getSid());
        if (metaInformation.isEmpty()) {
            return sb.closeEmptyElement();
        }
        return sb.rightAngleBracket().append(metaInformation).closeElement((NamedElement)this);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public int hashCode() {
        return HashCode.builder().append((Object)this.getElementName()).append((Object)this.getNamespace()).append((Object)this.getTarget()).append(this.getAuthParameters()).append(this.getCookies()).append(this.getHeaders()).build();
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals((Object)this, (Object)obj, (equalsBuilder, other) -> equalsBuilder.append((Object)this.getElementName(), (Object)other.getElementName()).append((Object)this.getNamespace(), (Object)other.getNamespace()).append((Object)this.getTarget(), (Object)other.getTarget()).append(this.getAuthParameters(), other.getAuthParameters()).append(this.getCookies(), other.getCookies()).append(this.getHeaders(), other.getHeaders()));
    }
}

