/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim;

import java.util.List;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.xhtmlim.XHTMLText;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;
import org.jxmpp.jid.Jid;

public class XHTMLManager {
    public static List<CharSequence> getBodies(MessageView message) {
        XHTMLExtension xhtmlExtension = XHTMLExtension.from(message);
        if (xhtmlExtension != null) {
            return xhtmlExtension.getBodies();
        }
        return null;
    }

    public static void addBody(MessageBuilder messageBuilder, XHTMLText xhtmlText) {
        XHTMLExtension xhtmlExtension = XHTMLExtension.from((MessageView)messageBuilder);
        if (xhtmlExtension == null) {
            xhtmlExtension = new XHTMLExtension();
            messageBuilder.addExtension((XmlElement)xhtmlExtension);
        }
        xhtmlExtension.addBody((CharSequence)xhtmlText.toXML());
    }

    @Deprecated
    public static void addBody(Message message, XHTMLText xhtmlText) {
        XHTMLExtension xhtmlExtension = XHTMLExtension.from((MessageView)message);
        if (xhtmlExtension == null) {
            xhtmlExtension = new XHTMLExtension();
            message.addExtension((XmlElement)xhtmlExtension);
        }
        xhtmlExtension.addBody((CharSequence)xhtmlText.toXML());
    }

    public static boolean isXHTMLMessage(Message message) {
        return message.getExtensionElement("html", "http://jabber.org/protocol/xhtml-im") != null;
    }

    public static synchronized void setServiceEnabled(XMPPConnection connection, boolean enabled) {
        if (XHTMLManager.isServiceEnabled(connection) == enabled) {
            return;
        }
        if (enabled) {
            ServiceDiscoveryManager.getInstanceFor(connection).addFeature("http://jabber.org/protocol/xhtml-im");
        } else {
            ServiceDiscoveryManager.getInstanceFor(connection).removeFeature("http://jabber.org/protocol/xhtml-im");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        return ServiceDiscoveryManager.getInstanceFor(connection).includesFeature("http://jabber.org/protocol/xhtml-im");
    }

    public static boolean isServiceEnabled(XMPPConnection connection, Jid userID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).supportsFeature(userID, "http://jabber.org/protocol/xhtml-im");
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                XHTMLManager.setServiceEnabled(connection, true);
            }
        });
    }
}

