/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaFactory;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.address.MultipleRecipientInfo;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class MultipleRecipientManager {
    public static void send(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException, InterruptedException {
        MultipleRecipientManager.send(connection, packet, to, cc, bcc, null, null, false);
    }

    public static void send(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc, Jid replyTo, Jid replyRoom, boolean noReply) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException, InterruptedException {
        if (to != null && to.size() == 1 && (cc == null || cc.isEmpty()) && (bcc == null || bcc.isEmpty()) && !noReply && StringUtils.isNullOrEmpty((CharSequence)replyTo) && StringUtils.isNullOrEmpty((CharSequence)replyRoom)) {
            Jid toJid = to.iterator().next();
            packet.setTo(toJid);
            connection.sendStanza(packet);
            return;
        }
        DomainBareJid serviceAddress = MultipleRecipientManager.getMultipleRecipientServiceAddress(connection);
        if (serviceAddress != null) {
            MultipleRecipientManager.sendThroughService(connection, packet, to, cc, bcc, replyTo, replyRoom, noReply, serviceAddress);
        } else {
            if (noReply || replyTo != null || replyRoom != null) {
                throw new SmackException.FeatureNotSupportedException("Extended Stanza Addressing");
            }
            MultipleRecipientManager.sendToIndividualRecipients(connection, (StanzaView)packet, to, cc, bcc);
        }
    }

    public static void reply(XMPPConnection connection, Message original, Message reply) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.FeatureNotSupportedException {
        MultipleAddresses.Address replyAddress;
        MultipleRecipientInfo info = MultipleRecipientManager.getMultipleRecipientInfo((Stanza)original);
        if (info == null) {
            throw new IllegalArgumentException("Original message does not contain multiple recipient info");
        }
        if (info.shouldNotReply()) {
            throw new IllegalArgumentException("Original message should not be replied");
        }
        if (info.getReplyRoom() != null) {
            throw new IllegalArgumentException("Reply should be sent through a room");
        }
        if (original.getThread() != null) {
            reply.asBuilder().setThread(original.getThread()).build();
        }
        if ((replyAddress = info.getReplyAddress()) != null && replyAddress.getJid() != null) {
            reply.setTo(replyAddress.getJid());
            connection.sendStanza((Stanza)reply);
        } else {
            EntityFullJid from;
            ArrayList<Jid> to = new ArrayList<Jid>(info.getTOAddresses().size());
            ArrayList<Jid> cc = new ArrayList<Jid>(info.getCCAddresses().size());
            for (MultipleAddresses.Address jid : info.getTOAddresses()) {
                to.add(jid.getJid());
            }
            for (MultipleAddresses.Address jid : info.getCCAddresses()) {
                cc.add(jid.getJid());
            }
            if (!to.contains(original.getFrom()) && !cc.contains(original.getFrom())) {
                to.add(original.getFrom());
            }
            if (!to.remove(from = connection.getUser()) && !cc.remove(from)) {
                EntityBareJid bareJID = from.asEntityBareJid();
                to.remove(bareJID);
                cc.remove(bareJID);
            }
            MultipleRecipientManager.send(connection, (Stanza)reply, to, cc, null, null, null, false);
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Stanza packet) {
        MultipleAddresses extension = (MultipleAddresses)packet.getExtension(MultipleAddresses.class);
        return extension == null ? null : new MultipleRecipientInfo(extension);
    }

    private static void sendToIndividualRecipients(XMPPConnection connection, StanzaView stanza, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc) throws SmackException.NotConnectedException, InterruptedException {
        MessageBuilder stanzaBuilder;
        StanzaFactory stanzaFactory = connection.getStanzaFactory();
        if (stanza instanceof Message) {
            Message message = (Message)stanza;
            stanzaBuilder = stanzaFactory.buildMessageStanzaFrom(message);
        } else if (stanza instanceof Presence) {
            Presence presence = (Presence)stanza;
            stanzaBuilder = stanzaFactory.buildPresenceStanzaFrom(presence);
        } else {
            if (stanza instanceof IQ) {
                throw new IllegalArgumentException("IQ stanzas have no supported fallback in case no XEP-0033 service is available");
            }
            throw new AssertionError();
        }
        if (to == null) {
            to = Collections.emptyList();
        }
        if (cc == null) {
            cc = Collections.emptyList();
        }
        if (bcc == null) {
            bcc = Collections.emptyList();
        }
        int numRecipients = to.size() + cc.size() + bcc.size();
        ArrayList<Object> recipients = new ArrayList<Object>(numRecipients);
        recipients.addAll(to);
        recipients.addAll(cc);
        recipients.addAll(bcc);
        ArrayList<Stanza> stanzasToSend = new ArrayList<Stanza>(numRecipients);
        for (Jid jid : recipients) {
            Stanza stanzaToSend = stanzaBuilder.to(jid).build();
            stanzasToSend.add(stanzaToSend);
        }
        for (Stanza stanza2 : stanzasToSend) {
            connection.sendStanza(stanza2);
        }
    }

    private static void sendThroughService(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc, Jid replyTo, Jid replyRoom, boolean noReply, DomainBareJid serviceAddress) throws SmackException.NotConnectedException, InterruptedException {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (to != null) {
            for (Jid jid : to) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, jid, null, null, false, null);
            }
        }
        if (cc != null) {
            for (Jid jid : cc) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, jid, null, null, false, null);
            }
        }
        if (bcc != null) {
            for (Jid jid : bcc) {
                multipleAddresses.addAddress(MultipleAddresses.Type.bcc, jid, null, null, false, null);
            }
        }
        if (noReply) {
            multipleAddresses.setNoReply();
        } else {
            if (replyTo != null) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyto, replyTo, null, null, false, null);
            }
            if (replyRoom != null) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyroom, replyRoom, null, null, false, null);
            }
        }
        packet.setTo((Jid)serviceAddress);
        packet.addExtension((XmlElement)multipleAddresses);
        connection.sendStanza(packet);
    }

    private static DomainBareJid getMultipleRecipientServiceAddress(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        return sdm.findService("http://jabber.org/protocol/address", true);
    }
}

