/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

class InitiationListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    protected InitiationListener(InBandBytestreamManager manager) {
        super("open", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = manager;
    }

    public IQ handleIQRequest(IQ iqRequest) {
        int maximumBlockSize;
        Open ibbRequest = (Open)iqRequest;
        int blockSize = ibbRequest.getBlockSize();
        if (blockSize > (maximumBlockSize = this.manager.getMaximumBlockSize())) {
            StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.resource_constraint).setDescriptiveEnText("Requests block size of " + blockSize + " exceeds maximum block size of " + maximumBlockSize)).build();
            return IQ.createErrorResponse((IQ)iqRequest, (StanzaError)error);
        }
        StreamNegotiator.signal(ibbRequest.getFrom().toString() + "\t" + ibbRequest.getSessionID(), ibbRequest);
        if (this.manager.getIgnoredBytestreamRequests().remove(ibbRequest.getSessionID())) {
            return null;
        }
        InBandBytestreamRequest request = new InBandBytestreamRequest(this.manager, ibbRequest);
        BytestreamListener userListener = this.manager.getUserListener(ibbRequest.getFrom());
        if (userListener != null) {
            userListener.incomingBytestreamRequest(request);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener listener : this.manager.getAllRequestListeners()) {
                listener.incomingBytestreamRequest(request);
            }
        } else {
            StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.not_acceptable).setDescriptiveEnText("No file-transfer listeners registered")).build();
            return IQ.createErrorResponse((IQ)iqRequest, (StanzaError)error);
        }
        return null;
    }
}

