/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.time.packet.Time;
import org.jivesoftware.smackx.time.packet.TimeView;
import org.jxmpp.util.XmppDateTime;

public class TimeBuilder
extends IqBuilder<TimeBuilder, Time>
implements TimeView {
    private String utc;
    private String tzo;

    TimeBuilder(IqData iqCommon) {
        super((AbstractIqBuilder)iqCommon);
    }

    TimeBuilder(XMPPConnection connection) {
        super(connection);
    }

    TimeBuilder(String stanzaId) {
        super(stanzaId);
    }

    public TimeBuilder setUtcAndTzo(String utc, String tzo) throws ParseException {
        this.utc = (String)StringUtils.requireNotNullNorEmpty((CharSequence)utc, (String)"Must provide utc argument");
        XmppDateTime.parseDate((String)utc);
        this.tzo = (String)StringUtils.requireNotNullNorEmpty((CharSequence)tzo, (String)"Must provide tzo argument");
        return this.getThis();
    }

    public TimeBuilder setTime(Calendar calendar) {
        this.utc = XmppDateTime.formatXEP0082Date((Date)calendar.getTime());
        this.tzo = XmppDateTime.asString((TimeZone)calendar.getTimeZone());
        return this.getThis();
    }

    @Override
    public String getUtc() {
        return this.utc;
    }

    @Override
    public String getTzo() {
        return this.tzo;
    }

    public Time build() {
        return new Time(this);
    }

    public TimeBuilder getThis() {
        return this;
    }
}

