/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.urldata.http.element;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.urldata.element.MetaInformationElement;
import org.jivesoftware.smackx.urldata.http.element.AuthParamElement;

public final class HttpAuthElement
implements MetaInformationElement {
    public static final String ELEMENT = "auth";
    public static final String PREFIX = "http";
    public static final String ATTR_SCHEME = "scheme";
    public static final String SCHEME_BASIC = "basic";
    private final String scheme;
    private final List<AuthParamElement> params = new ArrayList<AuthParamElement>();

    public HttpAuthElement(String scheme, List<AuthParamElement> params) {
        this.scheme = scheme;
        if (params != null) {
            this.params.addAll(params);
        }
    }

    public static HttpAuthElement basicAuth() {
        return HttpAuthElement.basicAuth(null, null);
    }

    public static HttpAuthElement basicAuth(String username, String password) {
        return HttpAuthElement.basicAuth(null, username, password);
    }

    public static HttpAuthElement basicAuth(String realm, String username, String password) {
        ArrayList<AuthParamElement> params = new ArrayList<AuthParamElement>();
        if (realm != null) {
            params.add(AuthParamElement.realm(realm));
        }
        if (username != null) {
            params.add(AuthParamElement.username(username));
        }
        if (password != null) {
            params.add(AuthParamElement.password(password));
        }
        return new HttpAuthElement(SCHEME_BASIC, params);
    }

    public String getScheme() {
        return this.scheme;
    }

    public List<AuthParamElement> getParams() {
        return this.params;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder sb = new XmlStringBuilder((NamedElement)this).attribute(ATTR_SCHEME, this.getScheme());
        if (this.getParams().isEmpty()) {
            return sb.closeEmptyElement();
        }
        return sb.rightAngleBracket().append(this.getParams()).closeElement((NamedElement)this);
    }

    public String getElementName() {
        return "http:auth";
    }

    public AuthParamElement getParam(String name) {
        for (AuthParamElement param : this.getParams()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public int hashCode() {
        return HashCode.builder().append((Object)this.getElementName()).append((Object)this.getScheme()).append(this.getParams()).build();
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals((Object)this, (Object)obj, (equalsBuilder, other) -> equalsBuilder.append((Object)this.getElementName(), (Object)other.getElementName()).append((Object)this.getScheme(), (Object)other.getScheme()).append(this.getParams(), other.getParams()));
    }
}

