/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder.java7;

import java.io.UnsupportedEncodingException;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jivesoftware.smack.util.stringencoder.java7.Base64;

public final class Java7Base64UrlSafeEncoder
implements StringEncoder {
    private static final Java7Base64UrlSafeEncoder instance = new Java7Base64UrlSafeEncoder();
    private static final int BASE64_ENCODER_FLAGS = 24;

    private Java7Base64UrlSafeEncoder() {
    }

    public static Java7Base64UrlSafeEncoder getInstance() {
        return instance;
    }

    public String encode(String s) {
        byte[] bytes;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        return Base64.encodeBytes(bytes, 24);
    }

    public String decode(String s) {
        try {
            return new String(Base64.decode(s, 24), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

