/*
 * Decompiled with CFR 0.152.
 */
package com.ikasan.sample.spring.boot.builderpattern;

import com.ikasan.sample.spring.boot.builderpattern.DbBroker;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.ikasan.builder.BuilderFactory;
import org.ikasan.spec.component.endpoint.Broker;
import org.ikasan.spec.component.endpoint.Consumer;
import org.ikasan.spec.component.endpoint.Producer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource(value={"classpath:ikasan-transaction-pointcut-jms.xml", "classpath:ikasan-transaction-pointcut-ikasanMessageListener.xml", "classpath:h2-datasource-conf.xml"})
public class ComponentFactory {
    @Resource
    private BuilderFactory builderFactory;
    @Value(value="${jms.producer.configuredResourceId}")
    String jmsProducerConfiguredResourceId;
    @Value(value="${jms.provider.url}")
    private String jmsProviderUrl;
    private String destinationName = "jms.topic.test";

    Consumer getJmsConsumer(String clientId) {
        ActiveMQXAConnectionFactory connectionFactory = new ActiveMQXAConnectionFactory(this.jmsProviderUrl);
        connectionFactory.setClientID(clientId);
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setMaximumRedeliveries(0);
        connectionFactory.setRedeliveryPolicy(redeliveryPolicy);
        return (Consumer)this.builderFactory.getComponentBuilder().jmsConsumer().setConnectionFactory((ConnectionFactory)connectionFactory).setDestinationJndiName(this.destinationName).setDurableSubscriptionName("testDurableSubscription").setDurable(Boolean.valueOf(true)).setAutoContentConversion(true).setAutoSplitBatch(true).setBatchMode(false).setBatchSize(1).setCacheLevel(4).setConcurrentConsumers(1).setMaxConcurrentConsumers(1).setSessionAcknowledgeMode(Integer.valueOf(0)).setSessionTransacted(Boolean.valueOf(true)).setPubSubDomain(Boolean.valueOf(true)).build();
    }

    Broker getDbBroker() {
        return new DbBroker();
    }

    Producer getJmsProducer() {
        ActiveMQXAConnectionFactory connectionFactory = new ActiveMQXAConnectionFactory(this.jmsProviderUrl);
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setMaximumRedeliveries(0);
        connectionFactory.setRedeliveryPolicy(redeliveryPolicy);
        return (Producer)this.builderFactory.getComponentBuilder().jmsProducer().setConfiguredResourceId(this.jmsProducerConfiguredResourceId).setDestinationJndiName(this.destinationName).setConnectionFactory((ConnectionFactory)connectionFactory).setSessionAcknowledgeMode(Integer.valueOf(0)).setSessionTransacted(Boolean.valueOf(true)).setPubSubDomain(Boolean.valueOf(true)).setDeliveryPersistent(Boolean.valueOf(true)).setDeliveryMode(Integer.valueOf(2)).setExplicitQosEnabled(Boolean.valueOf(true)).setMessageIdEnabled(Boolean.valueOf(true)).setMessageTimestampEnabled(Boolean.valueOf(true)).build();
    }
}

