/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.client;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import org.apache.log4j.Logger;
import org.ikasan.client.ConnectionCallback;

public class ConnectionTemplate {
    private static Logger logger = Logger.getLogger(ConnectionTemplate.class);
    private ConnectionFactory connectionFactory;
    private ConnectionSpec connectionSpec;

    public ConnectionTemplate(ConnectionFactory connectionFactory, ConnectionSpec connectionSpec) {
        this.connectionFactory = connectionFactory;
        this.connectionSpec = connectionSpec;
        if (connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionTemplate requires a non null ConnectionFactory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ConnectionCallback action) throws ResourceException {
        Object object;
        Connection connection = null;
        try {
            connection = this.connectionSpec != null ? this.connectionFactory.getConnection(this.connectionSpec) : this.connectionFactory.getConnection();
            object = action.doInConnection(connection);
        }
        catch (Throwable throwable) {
            ConnectionTemplate.closeConnection(connection);
            throw throwable;
        }
        ConnectionTemplate.closeConnection(connection);
        return object;
    }

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                logger.debug((Object)"Attempting to close EIS Connection");
                connection.close();
            }
            catch (ResourceException ex) {
                logger.warn((Object)"Could not close EIS Connection", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing EIS Connection", ex);
            }
        }
    }
}

