/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.compatibility.component.converter;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.TransformationException;

public class JmsMapSinglePayloadConverter
implements Converter<MapMessage, byte[]> {
    static String I8_PAYLOAD_0_CONTENT = String.valueOf("PAYLOAD_0_CONTENT");
    static final String I7_PAYLOAD_0_CONTENT = String.valueOf("payload_0_content");

    public byte[] convert(MapMessage mapMessage) throws TransformationException {
        try {
            byte[] payload = this.getMessageContent(mapMessage, I8_PAYLOAD_0_CONTENT);
            if (payload == null && (payload = this.getMessageContent(mapMessage, I7_PAYLOAD_0_CONTENT)) == null) {
                throw new JMSException("Cannot retrieve payload from mapMessage in either i8 field " + I8_PAYLOAD_0_CONTENT + " or i7 field " + I7_PAYLOAD_0_CONTENT);
            }
            return payload;
        }
        catch (JMSException e) {
            throw new TransformationException((Throwable)e);
        }
    }

    protected byte[] getMessageContent(MapMessage mapMessage, String payloadContent) throws JMSException {
        return mapMessage.getBytes(payloadContent);
    }
}

