/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.compatibility.component.converter;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.TransformationException;

public class JmsMapSinglePayloadTextConverter
implements Converter<MapMessage, String> {
    static String I8_PAYLOAD_0_CONTENT = String.valueOf("PAYLOAD_0_CONTENT");
    static final String I7_PAYLOAD_0_CONTENT = String.valueOf("payload_0_content");

    public String convert(MapMessage mapMessage) throws TransformationException {
        try {
            String payload = this.getMessageContent(mapMessage, I8_PAYLOAD_0_CONTENT);
            if (payload == null && (payload = this.getMessageContent(mapMessage, I7_PAYLOAD_0_CONTENT)) == null) {
                throw new JMSException("Cannot retrieve payload from mapMessage in either i8 field " + I8_PAYLOAD_0_CONTENT + " or i7 field " + I7_PAYLOAD_0_CONTENT);
            }
            return payload;
        }
        catch (JMSException e) {
            throw new TransformationException((Throwable)e);
        }
    }

    protected String getMessageContent(MapMessage mapMessage, String payloadContent) throws JMSException {
        byte[] bytesPayloadContent = mapMessage.getBytes(payloadContent);
        if (null == bytesPayloadContent) {
            return null;
        }
        return new String(bytesPayloadContent);
    }
}

