/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.compatibility.component.endpoint;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.ikasan.spec.event.ManagedEventIdentifierException;
import org.ikasan.spec.event.ManagedEventIdentifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedEventJmsIdentifierService
implements ManagedEventIdentifierService<String, MapMessage> {
    static String I8_EVENT_ID = String.valueOf("EVENT_ID");
    static String I7_ENVELOPE_ID = String.valueOf("envelope_id");
    private static Logger logger = LoggerFactory.getLogger(ManagedEventJmsIdentifierService.class);

    public void setEventIdentifier(String identifier, MapMessage mapMessage) throws ManagedEventIdentifierException {
        try {
            mapMessage.setString(I8_EVENT_ID, identifier);
        }
        catch (JMSException e) {
            throw new ManagedEventIdentifierException((Throwable)e);
        }
    }

    public String getEventIdentifier(MapMessage mapMessage) throws ManagedEventIdentifierException {
        try {
            String eventId = mapMessage.getString(I8_EVENT_ID);
            if (eventId == null && (eventId = mapMessage.getString(I7_ENVELOPE_ID)) == null) {
                eventId = mapMessage.getJMSMessageID();
            }
            return eventId;
        }
        catch (JMSException e) {
            throw new ManagedEventIdentifierException((Throwable)e);
        }
    }
}

