/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.routing;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.routing.RouterException;
import org.ikasan.framework.component.routing.SingleResultRouter;
import org.ikasan.framework.component.routing.UnroutableEventException;

public class FirstPayloadAttributeRouter
extends SingleResultRouter {
    private static Logger logger = Logger.getLogger(FirstPayloadAttributeRouter.class);
    private Map<String, String> attributeValuesRegexToResults = new HashMap<String, String>();
    private boolean returnsDefaultForNonMatches = false;
    private String attributeName;

    public FirstPayloadAttributeRouter(String attributeName, Map<String, String> attributeValuesToResults, boolean returnsDefaultForNonMatches) {
        if (attributeName == null || "".equals(attributeName)) {
            throw new IllegalArgumentException("non empty attributeName must be supplied on construction");
        }
        if (attributeValuesToResults != null) {
            this.attributeValuesRegexToResults.putAll(attributeValuesToResults);
        }
        this.attributeName = attributeName;
        this.returnsDefaultForNonMatches = returnsDefaultForNonMatches;
    }

    @Override
    protected String evaluate(Event event) throws RouterException {
        String result = null;
        Payload firstPayload = event.getPayloads().get(0);
        String payloadAttribute = firstPayload.getAttribute(this.attributeName);
        if (payloadAttribute != null) {
            for (Map.Entry<String, String> attributeValueRegexToResultEntry : this.attributeValuesRegexToResults.entrySet()) {
                String eventNameRegex = attributeValueRegexToResultEntry.getKey();
                Pattern pattern = Pattern.compile(eventNameRegex);
                Matcher matcher = pattern.matcher(payloadAttribute);
                if (!matcher.matches()) continue;
                result = attributeValueRegexToResultEntry.getValue();
            }
        }
        if (result == null) {
            if (this.returnsDefaultForNonMatches) {
                result = "default";
            } else {
                throw new UnroutableEventException("Could not route Event based on first payload's [" + this.attributeName + "] attribute, which was [" + payloadAttribute + "]");
            }
        }
        logger.info((Object)("evaluated Event [" + event.idToString() + "], obtained result [" + result + "]"));
        return result;
    }
}

