/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.routing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.routing.RouterException;
import org.ikasan.framework.component.routing.SingleResultRouter;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XMLValidatorRouter
extends SingleResultRouter {
    private static Logger logger = Logger.getLogger(XMLValidatorRouter.class);
    private static final String XML_VALID = "valid";
    private static final String XML_INVALID = "invalid";
    private DocumentBuilderFactory factory;
    private ErrorHandler errorHandler = new ExceptionThrowingErrorHandler();

    public XMLValidatorRouter(DocumentBuilderFactory factory) {
        this.factory = factory;
        if (this.factory == null) {
            throw new IllegalArgumentException("document builder factory cannot be 'null'.");
        }
    }

    @Override
    protected String evaluate(Event event) throws RouterException {
        String result = null;
        List<Payload> payloads = event.getPayloads();
        try {
            for (Payload payload : payloads) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Payload [" + payload.getId() + "]"));
                }
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                ByteArrayInputStream payloadContentAsInputStream = new ByteArrayInputStream(payload.getContent());
                builder.parse(payloadContentAsInputStream);
                result = XML_VALID;
            }
        }
        catch (SAXException e) {
            result = XML_INVALID;
        }
        catch (IOException e) {
            result = XML_INVALID;
        }
        catch (ParserConfigurationException e) {
            result = XML_INVALID;
        }
        if (result == null) {
            throw new RouterException("Unable to resolve to a routing transition for event.");
        }
        return result;
    }
}

