/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.routing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.routing.RouterException;
import org.ikasan.framework.component.routing.SingleResultRouter;
import org.ikasan.framework.component.routing.UnroutableEventException;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XPathSelectorRouter
extends SingleResultRouter {
    private static Logger logger = Logger.getLogger(XPathSelectorRouter.class);
    private DocumentBuilderFactory factory;
    private ErrorHandler errorHandler = new ExceptionThrowingErrorHandler();
    private String xpathExpression;
    private boolean returnsDefaultForNonMatches = false;

    public XPathSelectorRouter(DocumentBuilderFactory factory, String xpathExpression, boolean returnsDefaultForNonMatches) {
        this.factory = factory;
        if (this.factory == null) {
            throw new IllegalArgumentException("factory cannot be 'null'.");
        }
        this.xpathExpression = xpathExpression;
        if (this.xpathExpression == null || this.xpathExpression.length() == 0) {
            throw new IllegalArgumentException("xpath expression cannot be 'null' or empty.");
        }
        this.returnsDefaultForNonMatches = returnsDefaultForNonMatches;
    }

    public XPathSelectorRouter(DocumentBuilderFactory factory, String xpathExpression) {
        this(factory, xpathExpression, false);
    }

    @Override
    public String evaluate(Event event) throws RouterException {
        List<Payload> payloads = event.getPayloads();
        Payload primaryPayload = payloads.get(0);
        byte[] content = primaryPayload.getContent();
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            ByteArrayInputStream payloadContentAsInputStream = new ByteArrayInputStream(content);
            Document document = builder.parse(payloadContentAsInputStream);
            XPath xpathInst = XPathFactory.newInstance().newXPath();
            String result = (String)xpathInst.evaluate(this.xpathExpression, document, XPathConstants.STRING);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("xpath[" + this.xpathExpression + "] result[" + result + "]"));
            }
            if (result == null || result.length() == 0) {
                if (this.returnsDefaultForNonMatches) {
                    return "default";
                }
                throw new UnroutableEventException("Unable to resolve xpath expression [" + this.xpathExpression + "] to a value for event " + event.idToString());
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new RouterException(e);
        }
        catch (SAXException e) {
            logger.warn((Object)("Failed on content[" + new String(content) + "]"));
            throw new RouterException(e);
        }
        catch (IOException e) {
            throw new RouterException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RouterException(e);
        }
    }
}

